% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chartOptionsLegend.R
\name{chartOptionsLegend}
\alias{chartOptionsLegend}
\alias{chartOptionsLegend,Chart-method}
\title{Modifies the legend settings for a \code{\link{Chart-class}}}
\usage{
chartOptionsLegend(
  chart,
  show = NULL,
  showScenarioName = NULL,
  showScenarioId = NULL,
  showStageName = NULL,
  showTimestamp = NULL
)

\S4method{chartOptionsLegend}{Chart}(
  chart,
  show = NULL,
  showScenarioName = NULL,
  showScenarioId = NULL,
  showStageName = NULL,
  showTimestamp = NULL
)
}
\arguments{
\item{chart}{\code{\link{Chart-class}} object}

\item{show}{logical. Whether to show the chart legend. Default is \code{NULL}.}

\item{showScenarioName}{logical. Whether to show the scenario name in the
legend. Default is \code{NULL}.}

\item{showScenarioId}{logical. Whether to show the scenario ID in the legend.
Default is \code{NULL}.}

\item{showStageName}{logical. Determines whether to show the stage name
(i.e., transformer name) in the legend. Default is \code{NULL}.}

\item{showTimestamp}{logical. Whether to show the timestamp of the scenario
run in the legend. Default is \code{NULL}. Default is \code{NULL}.}
}
\value{
A \code{Chart} object representing a SyncroSim chart or, if no arguments
other than the chart are provided, a data.frame of the current chart legend
settings.
}
\description{
Modifies the legend settings for a \code{\link{Chart-class}}.
}
\examples{
\dontrun{
# Open a chart object
myChart <- chart(myProject, chart = "My Chart")

# Remove the scenario ID and the timestamp from the chart
myChart <- chartOptionsLegend(myChart, showScenarioId = FALSE, 
                              showTimestamp = FALSE)

# Hide the chart legend
myChart <- chartOptionsLegend(myChart, show = FALSE)
}

}
