% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/worldpop.R
\name{fit_population}
\alias{fit_population}
\alias{infer_population}
\title{Infer and fit a population model from \code{SurvStat} output}
\usage{
fit_population(count_df, .progress = TRUE)

infer_population(
  age_group = NULL,
  geography = NULL,
  years = NULL,
  .progress = TRUE
)
}
\arguments{
\item{count_df}{a dataframe from the output of \code{get_timeseries()} or \code{get_snapshot()}}

\item{.progress}{by default a progress bar is shown, which may be important
if many downloads are needed to fulfil the request. It can be disabled
by setting this to \code{FALSE} here.}

\item{age_group}{(optional) the age group of interest as a \code{SurvStat} key,
see \code{rsurvstat::age_groups} for a list of valid options.}

\item{geography}{(optional) one of \code{"state"}, \code{"nuts"}, or \code{"county"} to define the
resolution of the query. Does not accept a \code{sf} map or subset of
(unlike \code{get_timeseries()}).}

\item{years}{(optional) a vector of years to limit the response to. This may
be useful to limit the size of returned pages in the event the \code{SurvStat}
service hits a data transfer limit.}
}
\value{
the \code{count_df} dataframe with an additional \code{population} column

a dataframe with geography, age grouping, year and population columns
}
\description{
\code{SurvStat} can be queried for count or incidence. From the combination of
these metrics queried across the whole range of disease notifications for any
given year we can infer a stratified population size, that \code{SurvStat} is using
to calculate it's incidence. This is simply modelled with a local polynomial
over time to allow us to fill in weekly population denominators.
}
\section{Functions}{
\itemize{
\item \code{infer_population()}: Query \code{SurvStat} for data to impute a population denominator

}}
\examples{
\donttest{

# snapshot:
get_snapshot(
  disease = diseases$`COVID-19`,
  geography = "state",
  season=2024
) \%>\%
fit_population() \%>\%
dplyr::glimpse()

# timeseries
# A weekly population estimate is inferred from the yearly data:
get_timeseries(
  diseases$`COVID-19`,
  measure = "Count",
  age_group = age_groups$children_coarse
) \%>\%
fit_population() \%>\%
dplyr::glimpse()

}
\donttest{
infer_population(years=2020:2025) \%>\% dplyr::glimpse()
}
}
\concept{survstat}
