% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auth.R
\name{getOAuthCredentials}
\alias{getOAuthCredentials}
\title{Retrieve OAuth Credentials for Integrations}
\usage{
getOAuthCredentials(audience)
}
\arguments{
\item{audience}{The GUID of the OAuth integration configured in Posit Workbench.}
}
\value{
A list containing:
\describe{
\item{access_token}{The OAuth access token.}
\item{expiry}{The token expiry time as a POSIXct datetime object.}
\item{audience}{The integration GUID (audience) that was used to retrieve the credentials.}
}
Throws an error if the credentials cannot be retrieved or the integration is not found.
}
\description{
Retrieve OAuth credentials for a configured OAuth integration in Posit Workbench.
This function exchanges the current session for OAuth credentials that can be used
to authenticate with external services. This works in any IDE running within a
Posit Workbench session.
}
\note{
This function requires Posit Workbench version 2026.01.0 or later. It works
in any IDE running within a Posit Workbench session (not just RStudio).
}
\examples{
\dontrun{
# Retrieve OAuth credentials for an integration
creds <- getOAuthCredentials("4c1cfecb-1927-4f19-bc2f-d8ac261364e0")
if (!is.null(creds)) {
  cat("Access token:", creds$access_token, "\n")
  cat("Expires at:", format(creds$expiry), "\n")
}
}
}
