% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getLMS_JRS.R
\name{getLMS_JRS}
\alias{getLMS_JRS}
\title{Calculate L,M,S of JRS (Japanese Respiratory Society 2014) equations}
\usage{
getLMS_JRS(age, height, gender = 1, param = "FEV1")
}
\arguments{
\item{age}{Age in years}

\item{height}{Height in meters}

\item{gender}{Gender (1 = male, 2 = female) or a factor with two levels (first = male). Default is 1.}

\item{param}{A character vector, containing one of more of the following parameters (case insensitive):
"FEV1", "FVC", "FEV1FVC"}
}
\value{
A data.frame with L, M and S, for every patient and every parameter requested
}
\description{
This function calculates the L,M,S using the JRS (2014) equations
(Kubota et al, Respir Investig 2014). The output
of this function is used in calculating the LLN and predicted spirometry parameters.
Checking of the input is also performed here.
}
\details{
This is for internal use only.

Arguments \code{age}, \code{height} and \code{gender} are vectors
of equal length, or of length one, in which case the value is recycled; if the four vectors are
not of equal length, the function stops with an error.
}
\keyword{internal}
