% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LLN_GLIdiff.R
\name{LLN_GLIdiff}
\alias{LLN_GLIdiff}
\title{Calculate LLN of diffusing capacity parameters using GLI (2017) equations}
\usage{
LLN_GLIdiff(age, height, gender = 1, param = "TLCO", SI = TRUE)
}
\arguments{
\item{age}{Age in years}

\item{height}{Height in meters}

\item{gender}{Gender (1 = male, 2 = female) or a factor with two levels (first = male). Default is 1.}

\item{param}{A character vector, containing one of more of the following parameters (case insensitive):
"TLCO", "KCO" or "VA"}

\item{SI}{(default TRUE) Use SI (mmol/min/kPa) or traditional (ml/min/mmHg) units?}
}
\value{
If \code{param} has length one, the function returns a numeric vector. If \code{param}
has length >1, it returns a data.frame with \code{length(param)} columns.
}
\description{
This function calculates LLNs (Lower Limits of Normal) for TLCO
(transfer factor of the lung for carbon monoxide), KCO (transfer coefficient 
of the lung for carbon monoxide) and VA (alveolar volume)
using the GLI (2017) equations. 
It accepts as input age, height, gender.
}
\details{
Arguments \code{age}, \code{height} and \code{gender} are vectors
of equal length, or of length one, in which case the value is recycled; if the four vectors are
not of equal length, the function stops with an error.
}
\examples{
# Find LLN of TLCO and VA for women aged 20 to 70 and with a height of 1.70 meters.
LLN_GLIdiff(20:70, 1.7, 2, param=c("TLCO","VA"))

}
