% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/luluc.R
\name{build_luc_matrix}
\alias{build_luc_matrix}
\title{Build LUC matrix}
\usage{
build_luc_matrix(patterns, n_lu, n_years, out = vector())
}
\arguments{
\item{patterns}{A list of patterns.
Each pattern must be a sequence of transition values whose size is a multiple of \code{n_lu}x\code{n_lu}.
The \code{n_lu} first values are the transitions from each LU to the first LU, and so on.
If the sequence contains more years than \code{n_years}, it will be truncated.}

\item{n_lu}{Number of land use types (LU).}

\item{n_years}{Number of years (i.e. length of the 3rd dimension).}

\item{out}{For internal use only.}
}
\value{
An \code{n_lu}x\code{n_lu}x\code{n_years} transition matrix.
}
\description{
Build land-use change (LUC) transition matrix from patterns.
}
\examples{
# Example of building a 6 year-long transition matix consisting of 6 times 2x2 matrices

# A one time transfer of 0.5 of the total cell fraction from LU 2 to LU 1
pattern1 <- c(0, 0, 0.5, 0)
# The null pattern (no transition)
null_pattern <- rep(0, 4)
# A repeated self-transition of 0.1 of the total cell fraction from LU 2 to LU 2 every other year
pattern2 <- rep(c(c(0, 0, 0, 0.1), null_pattern), 3)

# Building the transition matrix
build_luc_matrix(list(pattern1, pattern2), 2, 6)
}
