% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_plink_text.R
\name{read.plink.text}
\alias{read.plink.text}
\title{Read PLINK text file.}
\usage{
read.plink.text(ped, map = NULL, output.allele = TRUE, na.strings = c("0",
  "-9"))
}
\arguments{
\item{ped, map}{PLINK files with appropraite extensions.}

\item{output.allele}{logical, default is to output genotype as alleles.}

\item{na.strings}{Character vector, set of characters to be treated as missing values.}
}
\value{
A list of three elements: \code{genotype}, \code{fam} and \code{map}.
To be consistent with PLINK .ped file, \code{genotype} by default is a n_subject by (2 x n_marker) matrix of alleles, where 1 represents the reference allele and 2 the alternate allele. Alternatively, genotype can be outputted as 0, 1 or 2 copies of reference allele count by using \code{output.allele = FALSE}. Missing values are -9.
\code{fam} is a dataframe that contains the first six columns of a PLINK \code{.ped} file.
\code{map} is a dataframe that contains the four columns of a PLINK \code{.map} file, with two additional columns: \code{allele_1} for the reference allele type, \code{allele_2} for the alternate allele type.
}
\description{
\code{read.plink.text} reads PLINK text files in either the original or transposed format.
}
\details{
The PLINK pedigree file should be supplied with the appropriate extension. The corresponding map file can be omitted if it has the same file name as the pedigree file and has the appropriate extension.
}
