% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{sim.haplotype}
\alias{sim.haplotype}
\title{Simulate artificial haplotypes.}
\usage{
sim.haplotype(freq, nhaplo)
}
\arguments{
\item{freq}{vector of values between 0 and 1.}

\item{nhaplo}{positive integer.}
}
\value{
A matrix of \code{nhaplo} rows and \code{length(freq)} columns. Reference alleles are coded 1, alternate alleles are coded 2.
}
\description{
\code{sim.haplotype} returns haplotypes of the specified number of SNPs simulated under linkage equilibrium.
}
\details{
\code{freq} are reference allele frequencies. \code{nhaplo} haplotypes are simulated independently.
}
\examples{
nsnp = 7 # number of SNPs
freq = runif(nsnp, 0.05, 0.95)
nhaplo = 4 # number of founder haplotypes
sim.haplotype(freq, nhaplo)
}
