% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_results.R
\name{extract_results}
\alias{extract_results}
\title{Create data frame with test results}
\usage{
extract_results(file, level = "task", hide_filename = TRUE)
}
\arguments{
\item{file}{A string with a path of the xml test result file.}

\item{level}{A string with two possible values: task and item.}

\item{hide_filename}{A boolean value, TRUE to hide original file names by
default.}
}
\value{
A dataframe with attribues of the candidates outcomes and result
variables.
}
\description{
The function \code{extract_results()} takes Opal zip archive "Export results" or
xml file and creates two kinds of data frames (according to parameter
'level'), see the 'Details' section.
}
\note{
1.With option level = "task" data frame consists of columns:
\itemize{
\item 'file' - name of the xml file with test results (to identify
candidate)
\item 'date' - date and time of test
\item 'id_question' - question item identifier
\item 'duration' - time in sec. what candidate spent on this item
\item 'score_candidate' - points that were given to candidate after evaluation
\item 'score_max' - max possible score for this question
\item 'is_answer_given' - TRUE if candidate gave the answer on question,
otherwise FALSE
\item 'title' - the values of attribute 'title' of assessment items
}

2.With option level = "item" data frame consists of columns:
\itemize{
\item 'file' - name of the xml file with test results (to identify
candidate)
\item 'date' - date and time of test
\item 'id_question' - question item identifier
\item 'base_type' - type of answer (identifier, string or float)
\item 'cardinalities' - defines whether this question is single, multiple or
ordered -value
\item 'qti_type' - specifies the type of the task
\item 'id_answer' - identifier of each response variable
\item 'expected_response' - values that considered as right responses for
question
\item 'candidate_response' - values that were given by candidate
\item 'score_candidate' - - points that were given to candidate after evaluation
\item 'score_max' - max possible score for this question item
\item 'is_response_correct' - TRUE if candidate gave the right response,
otherwise FALSE
\item 'title' - the values of attribute 'title' of assessment items
}
}
\examples{
\donttest{
file <- system.file("test_results.zip", package = "rqti")
df <- extract_results(file, level = "item")
}

}
