% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config.R
\docType{data}
\name{config}
\alias{config}
\alias{.registered}
\alias{config_load}
\alias{config_find_from}
\alias{config_from_desc}
\alias{config_from_file}
\title{Configuration}
\format{
An object of class \code{environment} of length 0.
}
\usage{
.registered

config_load(path = getwd(), cache = TRUE)

config_find_from(path)

config_from_desc(path)

config_from_file(path)
}
\arguments{
\item{path}{A file path to use when searching for a config file. Either the
file path to a \code{DESCRIPTION} or the root path of a package, depending on
the context of the function.}
}
\description{
Various functions for loading, caching and performing configured behaviors
using a user-supplied configuration file.
}
\section{Functions}{
\itemize{
\item \code{config_load()}: Load the contents of a config into an environment

\item \code{config_find_from()}: Load a configuration from a path

\item \code{config_from_desc()}: Load a configuration from a DESCRIPTION file

\item \code{config_from_file()}: Load a configuration from a dotfile

}}
\keyword{datasets}
\keyword{internal}
