% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{floating_point_comparisons}
\alias{floating_point_comparisons}
\alias{\%~=\%}
\alias{\%>~\%}
\alias{\%<~\%}
\title{Floating point comparison operators}
\usage{
x \%~=\% y

x \%>~\% y

x \%<~\% y
}
\arguments{
\item{x}{numeric}

\item{y}{numeric}
}
\description{
These are an important set of operators missing from base R. In particular,
using \code{==} on two non-interger numbers can give unexpected results (see examples.)

See this for details:
\url{https://docs.oracle.com/cd/E19957-01/806-3568/ncg_goldberg.html}
}
\examples{
 ## Floating point test of equality ####

 # Basic Equality - no roperators:
 (0.1 + 0.1 + 0.1) == 0.3   # FALSE
 # Basic Equality - with roperators:
 (0.1 + 0.1 + 0.1) \%~=\% 0.3 # TRUE


 # NOTE: for floating point >= and <=
 (0.1 + 0.1 + 0.1) \%>=\% 0.3 # TRUE
 (0.1 + 0.1 + 0.1) \%<=\% 0.3 # FALSE

 # Use >~ and <~ for greater/less than or approx equal
 (0.1 + 0.1 + 0.1) \%>~\% 0.3 # TRUE
 (0.1 + 0.1 + 0.1) \%<~\% 0.3 # TRUE

}
\seealso{
Other comparisons: 
\code{\link{comparisons}}
}
\author{
Ben Wiseman, \email{benjamin.wiseman@kornferry.com}
}
\concept{comparisons}
