% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.r
\name{bgGeneNorm}
\alias{bgGeneNorm}
\title{Normalise by background gene set}
\usage{
bgGeneNorm(x, threshold = 0.05)
}
\arguments{
\item{x}{Matrix to be normalised with cells in rows and
genes in columns}

\item{threshold}{Default 0.05. The threshold below which a gene is
deemed background}
}
\value{
Returns a normalised matrix of same dimenions as 'x'
}
\description{
Normalise by background gene set
}
\details{
Normalise by background gene set.
Find background genes that are expressed at a lower percentage of
the total library size per cell than 'threshold' parameter. These
genes are used to calculate a normalisation factor.
}
\examples{
\dontrun{
normGenes <- bgGeneNorm(x)
}
}
\author{
Wajid Jawaid
}
