% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match_consecutive_delimiters.R
\name{match_consecutive_delimiters}
\alias{match_consecutive_delimiters}
\title{Match the corresponding indices of (YAML) delimiters in a sequential list}
\usage{
match_consecutive_delimiters(
  x,
  errorOnInvalidX = FALSE,
  errorOnOdd = FALSE,
  onOddIgnoreFirst = FALSE
)
}
\arguments{
\item{x}{The vector with delimiter indices}

\item{errorOnInvalidX}{Whether to return \code{NA} (if \code{FALSE}) or throw an
error (if \code{TRUE}) when \code{x} is \code{NULL}, \code{NA}, or has less than 2 elements.}

\item{errorOnOdd}{Whether to throw an error if the number of delimiter
indices is odd.}

\item{onOddIgnoreFirst}{If the number of delimiter indices is odd and no
error is thrown, whether to ignore the first (\code{TRUE}) or the last (\code{FALSE})
delimiter.}
}
\value{
A list where each element is a two-element vector with the two
consecutive delimiters
}
\description{
This is just a convenience function that takes a vector of deliminaters
and returns a list of delimiter pairs.
}
\examples{
rock::match_consecutive_delimiters(
  c(1, 3, 5, 10, 19, 25, 30, 70)
);

exampleText <- c(
  "some text",
  "delimiter",
  "more text",
  "delimiter",
  "filler text",
  "intentionally left blank",
  "delimiter",
  "final text",
  "delimiter"
);

rock::match_consecutive_delimiters(
  grep(
    "delimiter",
    exampleText
  )
);
}
