% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_vectors_from_nested_list.R
\name{get_vectors_from_nested_list}
\alias{get_vectors_from_nested_list}
\title{Return one or more values from a nested list in a list of vectors}
\usage{
get_vectors_from_nested_list(x, valuesIn = NULL, nestingIn = "children")
}
\arguments{
\item{x}{The nested list}

\item{valuesIn}{The names holding the values to return (in vectors)}

\item{nestingIn}{The name containing the nested lists}
}
\value{
A list of vectors.
}
\description{
Return one or more values from a nested list in a list of vectors
}
\examples{
nestedList <-
  list(
    id = "x",
    value = "value for x",
    children = list(
      list(
        id = "y",
        value = "value for y"
      ),
      list(
        id = "z",
        value = "value for z"
      )
    )
  );
str(nestedList);
get_vectors_from_nested_list(
  nestedList,
  c("id", "value")
);
}
