% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monte_carlo.R
\name{mc_grid}
\alias{mc_grid}
\title{Monte Carlo simulations parameter grid}
\usage{
mc_grid(
  M,
  n,
  seed,
  parameters,
  formula,
  ref_dist,
  sign_level,
  initial_est,
  iterations,
  convergence_criterion = NULL,
  max_iter = NULL,
  shuffle = FALSE,
  shuffle_seed = 10,
  split = 0.5,
  path = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{M}{Number of replications.}

\item{n}{Sample size for each replication.}

\item{seed}{Random seed for the iterations.}

\item{parameters}{A list as created by \link{generate_param} that specifies
the true model.}

\item{formula}{A formula that specifies the 2SLS model to be estimated. The
format has to follow \code{y ~ x1 + x2 | x1 + z2}, where \code{y} is the
dependent variable, \code{x1} are the exogenous regressors, \code{x2} the
endogenous regressors, and \code{z2} the outside instruments.}

\item{ref_dist}{A character vector that specifies the reference distribution
against which observations are classified as outliers. \code{"normal"} refers
to the normal distribution.}

\item{sign_level}{A numeric value between 0 and 1 that determines the cutoff
in the reference distribution against which observations are judged as
outliers or not.}

\item{initial_est}{A character vector that specifies the initial estimator
for the outlier detection algorithm. \code{"robustified"} means that the full
sample 2SLS is used as initial estimator. \code{"saturated"} splits the
sample into two parts and estimates a 2SLS on each subsample. The
coefficients of one subsample are used to calculate residuals and determine
outliers in the other subsample. \code{"user"} allows the user to specify a
model based on which observations are classified as outliers.}

\item{iterations}{An integer >= 0 that specifies how often the outlier
detection algorithm is iterated and for which summary statistics will be
calculated. The value \code{0} means that outlier classification based on the
initial estimator is done. Alternatively, the character \code{"convergence"}
for iteration until convergence.}

\item{convergence_criterion}{A numeric value that determines whether the
algorithm has converged as measured by the L2 norm of the difference in
coefficients between the current and the previous iteration. Only used when
argument \code{iterations} is set to \code{"convergence"}.}

\item{max_iter}{A numeric value >= 1 or NULL. If
\code{iterations = "convergence"} is chosen, then the algorithm is stopped
after at most \code{max_iter} iterations. If also a
\code{convergence_criterion} is chosen then the algorithm stops when either
the criterion is fulfilled or the maximum number of iterations is reached.}

\item{shuffle}{A logical value or \code{NULL}.
\code{initial_est == "saturated"}. If \code{TRUE} then the sample is shuffled
before creating the subsamples.}

\item{shuffle_seed}{An integer value that will set the seed for shuffling the
sample or \code{NULL}. Only used if \code{initial_est == "saturated"} and
\code{shuffle == TRUE}.}

\item{split}{A numeric value strictly between 0 and 1 that determines
in which proportions the sample will be split.}

\item{path}{A character string or \code{FALSE}. The simulation grid can save
the individual results of each different entry in the grid to this
location. Individual results not saved if argument set to \code{FALSE}.}

\item{verbose}{A logical value whether any messages should be printed.}
}
\value{
\code{mc_grid} returns a data frame with the results of the Monte
Carlo experiments. Each row corresponds to a specific simulation setup. The
columns record the simulation setup and its results. Currently, the average
proportion of detected outliers ("mean_gauge") and their variance
("var_gauge") are being recorded. Moreover, the theoretical asymptotic
variance ("avar") and the ratio of simulated to theoretical variance -
adjusted by the sample size - are calculated ("var_ratio"). Furthermore,
tentative results of size and power for the tests are calculated.
}
\description{
WARNING: not for average user - function not completed yet
}
\details{
\code{mc_grid} runs Monte Carlo simulations to assess the performance of
the theory of the gauge, simple proportion tests, and count tests.
}
\section{Details}{

Requires the package \href{https://cran.r-project.org/package=doRNG}{doRNG}
to be installed, which has been orphaned as of 2022-12-09.

The following arguments can also be supplied as a vector of their type:
\code{n}, \code{sign_level}, \code{initial_est}, and \code{split}. This makes
the function estimate all possible combinations of the arguments. Note that
the initial estimator \code{"robustified"} is not affected by the argument
\code{split} and hence is not varied in this case.

For example, specifying \code{n = c(100, 1000)} and
\code{sign_level = c(0.01, 0.05)} estimates four Monte Carlo experiments with
the four possible combinations of the parameters.

The \code{path} argument allows users to store the \code{M} replication
results for all of the individual Monte Carlo simulations that are part of
the grid. The results are saved both as \code{.Rds} and \code{.csv} files.
The file name is indicative of the simulation setting.
}

