% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ROBIN_external_function.R
\name{robinRobust}
\alias{robinRobust}
\title{robinRobust}
\usage{
robinRobust(
  graph,
  graphRandom,
  method = c("walktrap", "edgeBetweenness", "fastGreedy", "louvain", "spinglass",
    "leadingEigen", "labelProp", "infomap", "optimal", "leiden", "other"),
  ...,
  FUN = NULL,
  measure = c("vi", "nmi", "split.join", "adjusted.rand"),
  type = "independent",
  verbose = TRUE,
  dist = "Other",
  BPPARAM = BiocParallel::bpparam()
)
}
\arguments{
\item{graph}{The output of prepGraph.}

\item{graphRandom}{The output of random function.}

\item{method}{The clustering method, one of "walktrap", "edgeBetweenness", 
"fastGreedy", "louvain", "spinglass", "leadingEigen", "labelProp", "infomap",
"leiden","optimal".}

\item{...}{other parameter.}

\item{FUN}{in case the @method parameter is "other" there is the possibility 
to use a personal function passing its name through this parameter.
The personal parameter has to take as input the @graph and the @weights 
(that can be NULL), and has to return a community object.}

\item{measure}{The stability measure, one of "vi", "nmi", "split.join", 
"adjusted.rand" all normalized and used as distances.
"nmi" refers to 1- nmi and "adjusted.ran" refers to 1-adjusted.rand.}

\item{type}{The type of robin construction, dependent or independent.}

\item{verbose}{flag for verbose output (default as TRUE).}

\item{dist}{Option to rewire in a manner that retains overall graph weight 
regardless of distribution of edge weights. This option is invoked by putting 
any text into this field. Defaults to "Other". See
  \code{\link[perturbR]{rewireR}} for details.}

\item{BPPARAM}{the BiocParallel object of class \code{bpparamClass} that 
specifies the back-end to be used for computations. See
  \code{\link[BiocParallel]{bpparam}} for details.}
}
\value{
A list object with two matrices:
- the matrix "Mean" with the means of the procedure for the graph
- the matrix "MeanRandom" with the means of the procedure for the random graph.
}
\description{
This functions implements a procedure to examine the stability 
of the partition recovered by some algorithm against random perturbations 
of the original graph structure.
}
\examples{
my_file <- system.file("example/football.gml", package="robin")
graph <- prepGraph(file=my_file, file.format="gml")
graphRandom <- random(graph=graph)
robinRobust(graph=graph, graphRandom=graphRandom, method="leiden")
}
