% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoint_goldprice.R
\name{get_last_n_goldprices}
\alias{get_last_n_goldprices}
\title{Retrieves the last n gold prices.}
\usage{
get_last_n_goldprices(n)
}
\arguments{
\item{n}{number of gold prices to retrieve.}
}
\value{
nbp_api_response object containing the last n
gold prices.
}
\description{
Retrieves the last n gold prices.
}
\examples{
\donttest{
tryCatch(
  {
    ## Fetch the last 3 gold price values
    response <- get_last_n_goldprices(3)
    ## Preview response content
    response$content
  },
  error = function(e) message(e)
)
}

}
\seealso{
\url{https://api.nbp.pl/#cenyZlota}

Other goldprice: 
\code{\link{get_current_goldprice}()},
\code{\link{get_goldprice_from}()},
\code{\link{get_goldprice_from_interval}()},
\code{\link{get_todays_goldprice}()}
}
\concept{goldprice}
