% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic.R
\name{summary.rmtfit}
\alias{summary.rmtfit}
\title{Summary of the analysis results}
\usage{
\method{summary}{rmtfit}(object, tau = NULL, Kmax = NULL, ...)
}
\arguments{
\item{object}{An object returned by \code{\link{rmtfit}}.}

\item{tau}{A positive real number for the follow-up time; Default is the maximum
event time in the data.}

\item{Kmax}{A positive integer; If specified, the stage-wise estimates over
\code{Kmax}\eqn{,\ldots,K} will be aggregated.}

\item{...}{Additional arguments affecting the summary produced.}
}
\value{
An object of class \code{summary.rmtfit} with components
\item{WL}{A \eqn{2\times(K+2)}-dimensional matrix; Each row contains the estimates for the
stage-wise and overall restricted mean win times for each group.}
\item{tab}{A \eqn{(K+2)\times 4}-dimensional matrix summarizing the inferential results
for the stage-wise and overall restricted mean times in favor of treatment; Columns include
\code{Estimate}, \code{Std.Err}, \code{Z value}, and \code{Pr(>|z|)}.}
\item{...}{}
}
\description{
Summarize the overall and stage-wise inferential results for the restricted
mean times in favor of treatment at a user-specified length of follow-up.
}
\examples{
#See examples for rmtfit().
}
\seealso{
\code{\link{rmtfit}}, \code{\link{plot.rmtfit}}, \code{\link{bouquet}}.
}
\keyword{rmtfit}
