% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{hfaction}
\alias{hfaction}
\title{A dataset from the HF-ACTION trial}
\format{
A data frame with 1,448 rows and 5 variables:
\describe{
  \item{patid}{Unique patient ID.}
  \item{time}{Event time (years).}
  \item{status}{Event type; 1 = hospitalization, 2 = death.}
  \item{trt_ab}{1 = exercise training, 0 = usual care.}
  \item{age60}{1 = 60 years or older, 0 = otherwise.}
  }
}
\usage{
hfaction
}
\description{
Over two thousand heart failure patients across the USA, Canada, and France
participated in the Heart Failure: A Controlled Trial Investigating Outcomes of Exercise
Training (HF-ACTION) between 2003--2007 (O'Connor et al., 2009).
The primary objective of the trial was to evaluate the effect of adding exercise
training to the usual patient care on the composite endpoint of all-cause hospitalization
 and death.
The dataset here contains a subgroup of 426 non-ischemic patients
with baseline cardio-pulmonary exercise test less than or equal to nine minutes.
}
\references{
O'CONNOR, C. M., WHELLAN, D. J., LEE, K. L., KETEYIAN, S. J.,
 COOPER, L. S., ELLIS, S. J., LEIFER, E. S.,
KRAUS, W. E., KITZMAN, D. W., BLUMENTHAL, J. A. et al. (2009).
Efficacy and safety of exercise training in
 patients with chronic heart failure: Hf-action randomized controlled trial.
 J. Am. Med. Assoc. 301, 1439--1450.
}
\keyword{datasets}
