% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encrypt.R
\name{encrypt_raw}
\alias{encrypt_raw}
\alias{decrypt_raw}
\title{Low Level Encryption/Decryption or Raw Vectors with 'Authenticated Encryption with Additional Data' (AEAD)}
\usage{
encrypt_raw(x, key, additional_data = NULL)

decrypt_raw(src, key, additional_data = NULL)
}
\arguments{
\item{x}{Data to encrypt. Character string or raw vector.}

\item{key}{The encryption key. This may be a character string, a 32-byte raw vector
or a 64-character hex string (which encodes 32 bytes). When a shorter character string 
is given, a 32-byte key is derived using the Argon2 key derivation
function.}

\item{additional_data}{Additional data to include in the
authentication.  Raw vector or character string. Default: NULL.  
This additional data is \emph{not}
included with the encrypted data, but represents an essential
component of the message authentication. The same \code{additional_data} 
must be presented during both encryption and decryption for the message
to be authenticated.  See vignette on 'Additional Data'.}

\item{src}{Raw vector of data to decrypt}
}
\value{
\code{encrypt_raw()} returns a raw vector containing the \emph{nonce},
        \emph{mac} and the encrypted data
        
        \code{decrypt_raw()} returns the decrypted data as a raw vector
}
\description{
This is a low-level function for encrypting/decrypting data using
'Authenticated Encryption with Additional Data' (AEAD).  This encryption
scheme assures data confidentiality (privacy) i.e. the encrypted data is
impossible to understand without the knowledge of the secret \emph{key}.

The authenticity of the message is also assured i.e. the message is 
unforgeable.

Additional data can optionally be included in the encryption process. This data is 
not encrypted, nor is it included with the output. Instead this 
data is a part of the message authentication. See below for more details.
}
\details{
Implements authenticated encryption as documented here \url{https://monocypher.org/manual/aead}
}
\section{Technical Notes}{

The encryption functions in this package implement RFC 8439 ChaCha20-Poly1305
authenticated encryption with additional data. This algorithm combines
the ChaCha20 stream cipher with the Poly1305 message authentication code.
}

\examples{
# Encrypt/Decrypt a string or raw vector
# Data to encrypt
dat <- "Follow the white rabbit" |> charToRaw()

# Create an encryption key
key <- argon2("my secret key") # Keep this key secret!
key

# Encrypt the data
enc <- encrypt_raw(dat, key)
enc

# Using the same key, decrypt the data 
decrypt_raw(enc, key) |> rawToChar()
}
