% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipynbcount.R
\name{ipynbcount}
\alias{ipynbcount}
\title{Count text elements in Jupyter Notebook files}
\usage{
ipynbcount(
  files,
  celltype = c("markdown"),
  space = "[[:space:]]",
  word = "[[:space:]]+",
  line = "\\n",
  exclude = "```\\\\{.*?```"
)
}
\arguments{
\item{files}{character: vector of paths to \code{.ipynb} (Jupyter Notebook) files.}

\item{celltype}{character: vector indicating which cell types to include (default is \code{'markdown'}). Valid values include \code{'markdown'} and \code{'code'}.}

\item{space}{character: pattern to split a text at spaces (default: \code{'[[:space:]]'})}

\item{word}{character: pattern to split a text at word boundaries (default: \code{'[[:space:]]+'})}

\item{line}{character: pattern to split lines (default: \code{'\n'})}

\item{exclude}{character: pattern to exclude text parts, e.g. code chunks (default: \code{'```\\\{.*?```'})}
}
\value{
A data frame with counts of characters, words, and lines for each file. Additional columns include \code{file} (base name) and \code{path} (directory).
}
\description{
This function extracts text from specific cell types (e.g., markdown) in one or more \code{.ipynb} files
and counts the number of characters, words, and lines. It optionally excludes certain patterns (e.g., code fences).
The function uses a helper function \code{rmdcount()} to perform the counting on the extracted text.
}
\details{
This function assumes that the notebook files are valid JSON and contain a list of cells under the \code{cells} field.
It temporarily writes the extracted content to a file to reuse the \code{rmdcount()} logic.
}
\examples{
file <- system.file('ipynb/example_data_analysis.ipynb', package="rmdwc")
ipynbcount(file)                                   # without code
ipynbcount(file, celltype=c("markdown", "code"))   # with code

}
