// Generated by rstantools.  Do not edit by hand.

/*
    rmBayes is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    rmBayes is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with rmBayes.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.32.2
#include <stan/model/model_header.hpp>
namespace model_HDIdUnif_namespace {
using stan::model::model_base_crtp;
using namespace stan::math;
stan::math::profile_map profiles__;
static constexpr std::array<const char*, 27> locations_array__ =
  {" (found before start of program)",
  " (in 'HDIdUnif', line 9, column 2 to column 10)",
  " (in 'HDIdUnif', line 10, column 2 to column 22)",
  " (in 'HDIdUnif', line 11, column 2 to column 20)",
  " (in 'HDIdUnif', line 12, column 2 to column 20)",
  " (in 'HDIdUnif', line 13, column 2 to column 14)",
  " (in 'HDIdUnif', line 14, column 2 to column 14)",
  " (in 'HDIdUnif', line 29, column 2 to column 19)",
  " (in 'HDIdUnif', line 30, column 2 to column 18)",
  " (in 'HDIdUnif', line 31, column 2 to column 23)",
  " (in 'HDIdUnif', line 32, column 2 to column 32)",
  " (in 'HDIdUnif', line 33, column 2 to column 32)",
  " (in 'HDIdUnif', line 19, column 4 to column 40)",
  " (in 'HDIdUnif', line 18, column 17 to line 20, column 3)",
  " (in 'HDIdUnif', line 18, column 2 to line 20, column 3)",
  " (in 'HDIdUnif', line 21, column 2 to column 21)",
  " (in 'HDIdUnif', line 22, column 2 to column 21)",
  " (in 'HDIdUnif', line 25, column 2 to column 24)",
  " (in 'HDIdUnif', line 2, column 2 to column 17)",
  " (in 'HDIdUnif', line 3, column 2 to column 17)",
  " (in 'HDIdUnif', line 5, column 8 to column 9)",
  " (in 'HDIdUnif', line 5, column 18 to column 19)",
  " (in 'HDIdUnif', line 5, column 2 to column 23)",
  " (in 'HDIdUnif', line 6, column 2 to column 13)",
  " (in 'HDIdUnif', line 13, column 9 to column 10)",
  " (in 'HDIdUnif', line 14, column 9 to column 10)",
  " (in 'HDIdUnif', line 30, column 9 to column 10)"};
#include <stan_meta_header.hpp>
class model_HDIdUnif final : public model_base_crtp<model_HDIdUnif> {
private:
  int N;
  int C;
  std::vector<Eigen::Matrix<double,-1,1>> Y;
  double tcrit;
public:
  ~model_HDIdUnif() {}
  model_HDIdUnif(stan::io::var_context& context__, unsigned int
                 random_seed__ = 0, std::ostream* pstream__ = nullptr)
      : model_base_crtp(0) {
    int current_statement__ = 0;
    using local_scalar_t__ = double;
    boost::ecuyer1988 base_rng__ =
      stan::services::util::create_rng(random_seed__, 0);
    // suppress unused var warning
    (void) base_rng__;
    static constexpr const char* function__ =
      "model_HDIdUnif_namespace::model_HDIdUnif";
    // suppress unused var warning
    (void) function__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      current_statement__ = 18;
      context__.validate_dims("data initialization", "N", "int",
        std::vector<size_t>{});
      N = std::numeric_limits<int>::min();
      current_statement__ = 18;
      N = context__.vals_i("N")[(1 - 1)];
      current_statement__ = 18;
      stan::math::check_greater_or_equal(function__, "N", N, 1);
      current_statement__ = 19;
      context__.validate_dims("data initialization", "C", "int",
        std::vector<size_t>{});
      C = std::numeric_limits<int>::min();
      current_statement__ = 19;
      C = context__.vals_i("C")[(1 - 1)];
      current_statement__ = 19;
      stan::math::check_greater_or_equal(function__, "C", C, 2);
      current_statement__ = 20;
      stan::math::validate_non_negative_index("Y", "N", N);
      current_statement__ = 21;
      stan::math::validate_non_negative_index("Y", "C", C);
      current_statement__ = 22;
      context__.validate_dims("data initialization", "Y", "double",
        std::vector<size_t>{static_cast<size_t>(N), static_cast<size_t>(C)});
      Y = std::vector<Eigen::Matrix<double,-1,1>>(N,
            Eigen::Matrix<double,-1,1>::Constant(C,
              std::numeric_limits<double>::quiet_NaN()));
      {
        std::vector<local_scalar_t__> Y_flat__;
        current_statement__ = 22;
        Y_flat__ = context__.vals_r("Y");
        current_statement__ = 22;
        pos__ = 1;
        current_statement__ = 22;
        for (int sym1__ = 1; sym1__ <= C; ++sym1__) {
          current_statement__ = 22;
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            current_statement__ = 22;
            stan::model::assign(Y, Y_flat__[(pos__ - 1)],
              "assigning variable Y", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 22;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 23;
      context__.validate_dims("data initialization", "tcrit", "double",
        std::vector<size_t>{});
      tcrit = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 23;
      tcrit = context__.vals_r("tcrit")[(1 - 1)];
      current_statement__ = 24;
      stan::math::validate_non_negative_index("t", "C", C);
      current_statement__ = 25;
      stan::math::validate_non_negative_index("b", "N", N);
      current_statement__ = 26;
      stan::math::validate_non_negative_index("hdi", "C", C);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    num_params_r__ = 1 + 1 + 1 + 1 + C + N;
  }
  inline std::string model_name() const final {
    return "model_HDIdUnif";
  }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.32.2",
             "stancflags = --allow-undefined"};
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI,
            stan::require_vector_like_t<VecR>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR>
  log_prob_impl(VecR& params_r__, VecI& params_i__, std::ostream*
                pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    static constexpr const char* function__ =
      "model_HDIdUnif_namespace::log_prob";
    // suppress unused var warning
    (void) function__;
    try {
      local_scalar_t__ mu = DUMMY_VAR__;
      current_statement__ = 1;
      mu = in__.template read<local_scalar_t__>();
      local_scalar_t__ sigma = DUMMY_VAR__;
      current_statement__ = 2;
      sigma = in__.template read_constrain_lb<local_scalar_t__,
                jacobian__>(0, lp__);
      local_scalar_t__ eta = DUMMY_VAR__;
      current_statement__ = 3;
      eta = in__.template read_constrain_lb<local_scalar_t__, jacobian__>(0,
              lp__);
      local_scalar_t__ tau = DUMMY_VAR__;
      current_statement__ = 4;
      tau = in__.template read_constrain_lb<local_scalar_t__, jacobian__>(0,
              lp__);
      Eigen::Matrix<local_scalar_t__,-1,1> t =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(C, DUMMY_VAR__);
      current_statement__ = 5;
      t = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(C);
      Eigen::Matrix<local_scalar_t__,-1,1> b =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(N, DUMMY_VAR__);
      current_statement__ = 6;
      b = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(N);
      {
        current_statement__ = 14;
        for (int i = 1; i <= N; ++i) {
          current_statement__ = 12;
          lp_accum__.add(stan::math::normal_lpdf<propto__>(
                           stan::model::rvalue(Y, "Y",
                             stan::model::index_uni(i)),
                           stan::math::add(stan::math::add(mu, t),
                             stan::model::rvalue(b, "b",
                               stan::model::index_uni(i))), sigma));
        }
        current_statement__ = 15;
        lp_accum__.add(stan::math::normal_lpdf<propto__>(t, 0, eta));
        current_statement__ = 16;
        lp_accum__.add(stan::math::normal_lpdf<propto__>(b, 0, tau));
        current_statement__ = 17;
        lp_accum__.add(-stan::math::log(sigma));
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
  }
  template <typename RNG, typename VecR, typename VecI, typename VecVar,
            stan::require_vector_like_vt<std::is_floating_point,
            VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral,
            VecI>* = nullptr, stan::require_vector_vt<std::is_floating_point,
            VecVar>* = nullptr>
  inline void
  write_array_impl(RNG& base_rng__, VecR& params_r__, VecI& params_i__,
                   VecVar& vars__, const bool
                   emit_transformed_parameters__ = true, const bool
                   emit_generated_quantities__ = true, std::ostream*
                   pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    static constexpr bool propto__ = true;
    // suppress unused var warning
    (void) propto__;
    double lp__ = 0.0;
    // suppress unused var warning
    (void) lp__;
    int current_statement__ = 0;
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    constexpr bool jacobian__ = false;
    static constexpr const char* function__ =
      "model_HDIdUnif_namespace::write_array";
    // suppress unused var warning
    (void) function__;
    try {
      double mu = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 1;
      mu = in__.template read<local_scalar_t__>();
      double sigma = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 2;
      sigma = in__.template read_constrain_lb<local_scalar_t__,
                jacobian__>(0, lp__);
      double eta = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 3;
      eta = in__.template read_constrain_lb<local_scalar_t__, jacobian__>(0,
              lp__);
      double tau = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 4;
      tau = in__.template read_constrain_lb<local_scalar_t__, jacobian__>(0,
              lp__);
      Eigen::Matrix<double,-1,1> t =
        Eigen::Matrix<double,-1,1>::Constant(C,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 5;
      t = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(C);
      Eigen::Matrix<double,-1,1> b =
        Eigen::Matrix<double,-1,1>::Constant(N,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 6;
      b = in__.template read<Eigen::Matrix<local_scalar_t__,-1,1>>(N);
      out__.write(mu);
      out__.write(sigma);
      out__.write(eta);
      out__.write(tau);
      out__.write(t);
      out__.write(b);
      if (stan::math::logical_negation(
            (stan::math::primitive_value(emit_transformed_parameters__) ||
            stan::math::primitive_value(emit_generated_quantities__)))) {
        return ;
      }
      if (stan::math::logical_negation(emit_generated_quantities__)) {
        return ;
      }
      double se = std::numeric_limits<double>::quiet_NaN();
      Eigen::Matrix<double,-1,-1> hdi =
        Eigen::Matrix<double,-1,-1>::Constant(C, 2,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 9;
      se = (sigma / stan::math::sqrt(N));
      current_statement__ = 10;
      stan::model::assign(hdi,
        stan::math::subtract(stan::math::add(mu, t), (tcrit * se)),
        "assigning variable hdi", stan::model::index_omni(),
        stan::model::index_uni(1));
      current_statement__ = 11;
      stan::model::assign(hdi,
        stan::math::add(stan::math::add(mu, t), (tcrit * se)),
        "assigning variable hdi", stan::model::index_omni(),
        stan::model::index_uni(2));
      current_statement__ = 7;
      stan::math::check_greater_or_equal(function__, "se", se, 0);
      out__.write(se);
      out__.write(hdi);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, typename VecI,
            stan::require_vector_t<VecVar>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void
  unconstrain_array_impl(const VecVar& params_r__, const VecI& params_i__,
                         VecVar& vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      local_scalar_t__ mu = DUMMY_VAR__;
      current_statement__ = 1;
      mu = in__.read<local_scalar_t__>();
      out__.write(mu);
      local_scalar_t__ sigma = DUMMY_VAR__;
      current_statement__ = 2;
      sigma = in__.read<local_scalar_t__>();
      out__.write_free_lb(0, sigma);
      local_scalar_t__ eta = DUMMY_VAR__;
      current_statement__ = 3;
      eta = in__.read<local_scalar_t__>();
      out__.write_free_lb(0, eta);
      local_scalar_t__ tau = DUMMY_VAR__;
      current_statement__ = 4;
      tau = in__.read<local_scalar_t__>();
      out__.write_free_lb(0, tau);
      Eigen::Matrix<local_scalar_t__,-1,1> t =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(C, DUMMY_VAR__);
      current_statement__ = 5;
      stan::model::assign(t,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(C),
        "assigning variable t");
      out__.write(t);
      Eigen::Matrix<local_scalar_t__,-1,1> b =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(N, DUMMY_VAR__);
      current_statement__ = 6;
      stan::model::assign(b,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(N),
        "assigning variable b");
      out__.write(b);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, stan::require_vector_t<VecVar>* = nullptr>
  inline void
  transform_inits_impl(const stan::io::var_context& context__, VecVar&
                       vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      current_statement__ = 1;
      context__.validate_dims("parameter initialization", "mu", "double",
        std::vector<size_t>{});
      current_statement__ = 2;
      context__.validate_dims("parameter initialization", "sigma", "double",
        std::vector<size_t>{});
      current_statement__ = 3;
      context__.validate_dims("parameter initialization", "eta", "double",
        std::vector<size_t>{});
      current_statement__ = 4;
      context__.validate_dims("parameter initialization", "tau", "double",
        std::vector<size_t>{});
      current_statement__ = 5;
      context__.validate_dims("parameter initialization", "t", "double",
        std::vector<size_t>{static_cast<size_t>(C)});
      current_statement__ = 6;
      context__.validate_dims("parameter initialization", "b", "double",
        std::vector<size_t>{static_cast<size_t>(N)});
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      local_scalar_t__ mu = DUMMY_VAR__;
      current_statement__ = 1;
      mu = context__.vals_r("mu")[(1 - 1)];
      out__.write(mu);
      local_scalar_t__ sigma = DUMMY_VAR__;
      current_statement__ = 2;
      sigma = context__.vals_r("sigma")[(1 - 1)];
      out__.write_free_lb(0, sigma);
      local_scalar_t__ eta = DUMMY_VAR__;
      current_statement__ = 3;
      eta = context__.vals_r("eta")[(1 - 1)];
      out__.write_free_lb(0, eta);
      local_scalar_t__ tau = DUMMY_VAR__;
      current_statement__ = 4;
      tau = context__.vals_r("tau")[(1 - 1)];
      out__.write_free_lb(0, tau);
      Eigen::Matrix<local_scalar_t__,-1,1> t =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(C, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> t_flat__;
        current_statement__ = 5;
        t_flat__ = context__.vals_r("t");
        current_statement__ = 5;
        pos__ = 1;
        current_statement__ = 5;
        for (int sym1__ = 1; sym1__ <= C; ++sym1__) {
          current_statement__ = 5;
          stan::model::assign(t, t_flat__[(pos__ - 1)],
            "assigning variable t", stan::model::index_uni(sym1__));
          current_statement__ = 5;
          pos__ = (pos__ + 1);
        }
      }
      out__.write(t);
      Eigen::Matrix<local_scalar_t__,-1,1> b =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(N, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> b_flat__;
        current_statement__ = 6;
        b_flat__ = context__.vals_r("b");
        current_statement__ = 6;
        pos__ = 1;
        current_statement__ = 6;
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          current_statement__ = 6;
          stan::model::assign(b, b_flat__[(pos__ - 1)],
            "assigning variable b", stan::model::index_uni(sym1__));
          current_statement__ = 6;
          pos__ = (pos__ + 1);
        }
      }
      out__.write(b);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  inline void
  get_param_names(std::vector<std::string>& names__, const bool
                  emit_transformed_parameters__ = true, const bool
                  emit_generated_quantities__ = true) const {
    names__ = std::vector<std::string>{"mu", "sigma", "eta", "tau", "t", "b"};
    if (emit_transformed_parameters__) {}
    if (emit_generated_quantities__) {
      std::vector<std::string> temp{"se", "hdi"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  get_dims(std::vector<std::vector<size_t>>& dimss__, const bool
           emit_transformed_parameters__ = true, const bool
           emit_generated_quantities__ = true) const {
    dimss__ = std::vector<std::vector<size_t>>{std::vector<size_t>{},
                std::vector<size_t>{}, std::vector<size_t>{},
                std::vector<size_t>{},
                std::vector<size_t>{static_cast<size_t>(C)},
                std::vector<size_t>{static_cast<size_t>(N)}};
    if (emit_transformed_parameters__) {}
    if (emit_generated_quantities__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{},
             std::vector<size_t>{static_cast<size_t>(C),
               static_cast<size_t>(2)}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  constrained_param_names(std::vector<std::string>& param_names__, bool
                          emit_transformed_parameters__ = true, bool
                          emit_generated_quantities__ = true) const final {
    param_names__.emplace_back(std::string() + "mu");
    param_names__.emplace_back(std::string() + "sigma");
    param_names__.emplace_back(std::string() + "eta");
    param_names__.emplace_back(std::string() + "tau");
    for (int sym1__ = 1; sym1__ <= C; ++sym1__) {
      param_names__.emplace_back(std::string() + "t" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
      param_names__.emplace_back(std::string() + "b" + '.' +
        std::to_string(sym1__));
    }
    if (emit_transformed_parameters__) {}
    if (emit_generated_quantities__) {
      param_names__.emplace_back(std::string() + "se");
      for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= C; ++sym2__) {
          param_names__.emplace_back(std::string() + "hdi" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
    }
  }
  inline void
  unconstrained_param_names(std::vector<std::string>& param_names__, bool
                            emit_transformed_parameters__ = true, bool
                            emit_generated_quantities__ = true) const final {
    param_names__.emplace_back(std::string() + "mu");
    param_names__.emplace_back(std::string() + "sigma");
    param_names__.emplace_back(std::string() + "eta");
    param_names__.emplace_back(std::string() + "tau");
    for (int sym1__ = 1; sym1__ <= C; ++sym1__) {
      param_names__.emplace_back(std::string() + "t" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
      param_names__.emplace_back(std::string() + "b" + '.' +
        std::to_string(sym1__));
    }
    if (emit_transformed_parameters__) {}
    if (emit_generated_quantities__) {
      param_names__.emplace_back(std::string() + "se");
      for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= C; ++sym2__) {
          param_names__.emplace_back(std::string() + "hdi" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
    }
  }
  inline std::string get_constrained_sizedtypes() const {
    return std::string("[{\"name\":\"mu\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"eta\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"tau\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"t\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(C) + "},\"block\":\"parameters\"},{\"name\":\"b\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"parameters\"},{\"name\":\"se\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"hdi\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(C) + ",\"cols\":" + std::to_string(2) + "},\"block\":\"generated_quantities\"}]");
  }
  inline std::string get_unconstrained_sizedtypes() const {
    return std::string("[{\"name\":\"mu\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"eta\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"tau\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"t\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(C) + "},\"block\":\"parameters\"},{\"name\":\"b\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"parameters\"},{\"name\":\"se\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"hdi\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(C) + ",\"cols\":" + std::to_string(2) + "},\"block\":\"generated_quantities\"}]");
  }
  // Begin method overload boilerplate
  template <typename RNG> inline void
  write_array(RNG& base_rng, Eigen::Matrix<double,-1,1>& params_r,
              Eigen::Matrix<double,-1,1>& vars, const bool
              emit_transformed_parameters = true, const bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = (((((1 + 1) + 1) + 1) + C) + N);
    const size_t num_transformed = emit_transformed_parameters * (0);
    const size_t num_gen_quantities = emit_generated_quantities * ((1 + (C *
      2)));
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    std::vector<int> params_i;
    vars = Eigen::Matrix<double,-1,1>::Constant(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <typename RNG> inline void
  write_array(RNG& base_rng, std::vector<double>& params_r, std::vector<int>&
              params_i, std::vector<double>& vars, bool
              emit_transformed_parameters = true, bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = (((((1 + 1) + 1) + 1) + C) + N);
    const size_t num_transformed = emit_transformed_parameters * (0);
    const size_t num_gen_quantities = emit_generated_quantities * ((1 + (C *
      2)));
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    vars = std::vector<double>(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(Eigen::Matrix<T_,-1,1>& params_r, std::ostream* pstream = nullptr) const {
    Eigen::Matrix<int,-1,1> params_i;
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(std::vector<T_>& params_r, std::vector<int>& params_i,
           std::ostream* pstream = nullptr) const {
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  inline void
  transform_inits(const stan::io::var_context& context,
                  Eigen::Matrix<double,-1,1>& params_r, std::ostream*
                  pstream = nullptr) const final {
    std::vector<double> params_r_vec(params_r.size());
    std::vector<int> params_i;
    transform_inits(context, params_i, params_r_vec, pstream);
    params_r = Eigen::Map<Eigen::Matrix<double,-1,1>>(params_r_vec.data(),
                 params_r_vec.size());
  }
  inline void
  transform_inits(const stan::io::var_context& context, std::vector<int>&
                  params_i, std::vector<double>& vars, std::ostream*
                  pstream__ = nullptr) const {
    vars.resize(num_params_r__);
    transform_inits_impl(context, vars, pstream__);
  }
  inline void
  unconstrain_array(const std::vector<double>& params_constrained,
                    std::vector<double>& params_unconstrained, std::ostream*
                    pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = std::vector<double>(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
  inline void
  unconstrain_array(const Eigen::Matrix<double,-1,1>& params_constrained,
                    Eigen::Matrix<double,-1,1>& params_unconstrained,
                    std::ostream* pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = Eigen::Matrix<double,-1,1>::Constant(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
};
}
using stan_model = model_HDIdUnif_namespace::model_HDIdUnif;
#ifndef USING_R
// Boilerplate
stan::model::model_base&
new_model(stan::io::var_context& data_context, unsigned int seed,
          std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_HDIdUnif_namespace::profiles__;
}
#endif
#endif
