% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rlistings_methods.R
\name{format_colvector}
\alias{format_colvector}
\alias{vec_nlines}
\alias{vec_nlines,ANY-method}
\title{Utilities for formatting a listing column}
\usage{
format_colvector(
  df,
  colnm,
  colvec = df[[colnm]],
  round_type = valid_round_type
)

vec_nlines(
  vec,
  max_width = NULL,
  fontspec = dflt_courier,
  round_type = valid_round_type
)

\S4method{vec_nlines}{ANY}(
  vec,
  max_width = NULL,
  fontspec = dflt_courier,
  round_type = valid_round_type
)
}
\arguments{
\item{df}{(\code{listing_df})\cr the listing.}

\item{colnm}{(\code{string})\cr column name.}

\item{colvec}{(\code{vector})\cr column values based on \code{colnm}.}

\item{round_type}{(\code{string})\cr the type of rounding to perform.
Allowed values are (\code{"iec"} (default), \code{"iec_mod"} or \code{"sas"}).
\cr See \code{\link[formatters:format_value]{formatters::format_value()}} for details.}

\item{vec}{(\code{vector})\cr a vector.}

\item{max_width}{(\code{numeric(1)} or \code{NULL})\cr the width to render the column with.}
}
\value{
(\code{numeric})\cr a vector of the number of lines element-wise that will be
needed to render the elements of \code{vec} to width \code{max_width}.
}
\description{
For \code{vec_nlines}, calculate the number of lines each element of a column vector will
take to render. For \code{format_colvector},
}
\keyword{internal}
