% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plotGroupClusterDimRed}
\alias{plotGroupClusterDimRed}
\title{Comprehensive group splited cluster plot on dimension reduction with
proportion}
\usage{
plotGroupClusterDimRed(
  object,
  useGroup = "dataset",
  useCluster = NULL,
  useDimRed = NULL,
  combinePlot = TRUE,
  droplevels = TRUE,
  relHeightMainLegend = c(5, 1),
  relHeightDRBar = c(10, 1),
  mainNRow = NULL,
  mainNCol = NULL,
  legendNRow = 1,
  ...
)
}
\arguments{
\item{object}{A \linkS4class{liger} object with dimension reduction, grouping
variable and cluster assignment in \code{cellMeta(object)}.}

\item{useGroup}{Variable name of the group division in metadata. Default
\code{"dataset"}.}

\item{useCluster}{Name of variable in \code{cellMeta(object)}. Default
\code{NULL} uses default cluster.}

\item{useDimRed}{Name of the variable storing dimensionality reduction result
in \code{cellMeta(object)}. Default \code{NULL} use default dimRed.}

\item{combinePlot}{Whether to return combined plot. Default \code{TRUE}. If
\code{FALSE}, will return a list containing only the scatter plots.}

\item{droplevels}{Logical, whether to perform \code{\link{droplevels}()} on
the selected grouping variable. Default \code{TRUE} will not show groups that
are listed as categories but do not indeed have any cells.}

\item{relHeightMainLegend}{Relative heights of the main combination panel and
the legend at the bottom. Must be a numeric vector of 2 numbers. Default
\code{c(5, 1)}.}

\item{relHeightDRBar}{Relative heights of the scatter plot and the barplot
within each subpanel. Must be a numeric vector of 2 numbers. Default
\code{c(10, 1)}.}

\item{mainNRow, mainNCol}{Arrangement of the main plotting region, for number
of rows and columns. Default \code{NULL} will be automatically handled by
\code{\link[cowplot]{plot_grid}}.}

\item{legendNRow}{Arrangement of the legend, number of rows. Default
\code{1}.}

\item{...}{
  Arguments passed on to \code{\link[=.ggScatter]{.ggScatter}}, \code{\link[=.ggplotLigerTheme]{.ggplotLigerTheme}}
  \describe{
    \item{\code{dotOrder}}{Controls the order that each dot is added to the plot. Choose
from \code{"shuffle"}, \code{"ascending"}, or \code{"descending"}. Default
\code{"shuffle"}, useful when coloring by categories that overlaps (e.g.
"dataset"), \code{"ascending"} can be useful when coloring by a continuous
variable (e.g. gene expression) where high values needs more
highlight. \code{NULL} use default order.}
    \item{\code{dotSize,dotAlpha}}{Numeric, controls the size or transparency of all
dots. Default \code{getOption("ligerDotSize")} (1) and \code{0.9}.}
    \item{\code{raster}}{Logical, whether to rasterize the plot. Default \code{NULL}
automatically rasterize the plot when number of total dots to be plotted
exceeds 100,000.}
    \item{\code{labelText}}{Logical, whether to show text label at the median position
of each categorical group specified by \code{colorBy}. Default \code{TRUE}.
Does not work when continuous coloring is specified.}
    \item{\code{labelTextSize}}{Numeric, controls the size of label size when
\code{labelText = TRUE}. Default \code{4}.}
    \item{\code{seed}}{Random seed for reproducibility. Default \code{1}.}
    \item{\code{baseSize}}{One-parameter control of all text sizes. Individual text
element sizes can be controlled by other size arguments. "Title" sizes are
2 points larger than "text" sizes when being controlled by this.}
    \item{\code{panelBorder}}{Whether to show rectangle border of the panel instead of
using ggplot classic bottom and left axis lines. Default \code{FALSE}.}
    \item{\code{colorValues}}{Character vector of colors for modifying category colors
in a color legend. Passed to \code{ggplot2::scale_color_manual(values)}.
Default \code{NULL} uses internal selected palette when <= 26 categories are
presented, otherwise ggplot hues.}
    \item{\code{naColor}}{The color code for \code{NA} values. Default \code{"#DEDEDE"}.
\code{\link[ggplot2]{scale_colour_gradient2}}. Default \code{NULL}.}
    \item{\code{plotly}}{Whether to use plotly to enable web based interactive browsing
for the plot. Requires installation of package "plotly". Default
\code{FALSE}.}
  }}
}
\value{
ggplot object when only one feature (e.g. cluster variable, gene,
factor) is set. List object when multiple of those are specified.
}
\description{
This function produces combined plot on group level (e.g. dataset, other
metadata variable like biological conditions). Scatter plot of dimension
reduction with cluster labeled is generated per group. Furthermore, a stacked
barplot of cluster proportion within each group is also combined with the
subplot of each group.
}
\examples{
plotGroupClusterDimRed(pbmcPlot)
}
