% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classConversion.R
\name{convertOldLiger}
\alias{convertOldLiger}
\title{Convert old liger object to latest version}
\usage{
convertOldLiger(
  object,
  dimredName,
  clusterName = "clusters",
  h5FilePath = NULL
)
}
\arguments{
\item{object}{\code{liger} object from rliger version <1.99.0}

\item{dimredName}{The name of variable in \code{cellMeta} slot to store the
dimensionality reduction matrix, which originally located in
\code{tsne.coords} slot. Default \code{"tsne.coords"}.}

\item{clusterName}{The name of variable in \code{cellMeta} slot to store the
clustering assignment, which originally located in \code{clusters} slot.
Default \code{"clusters"}.}

\item{h5FilePath}{Named list, to specify the path to the H5 file of each
dataset if location has been changed. Default \code{NULL} looks at the file
paths stored in object.}
}
\description{
Convert old liger object to latest version
}
\examples{
\dontrun{
# Suppose you have a liger object of old version (<1.99.0)
newLig <- convertOldLiger(oldLig)
}
}
