% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ligerCommand_relates.R
\name{commandDiff}
\alias{commandDiff}
\title{Check difference of two liger command}
\usage{
commandDiff(object, cmd1, cmd2)
}
\arguments{
\item{object}{\linkS4class{liger} object}

\item{cmd1, cmd2}{Exact string of command labels. Available options could be
viewed with running \code{commands(object)}.}
}
\value{
If any difference found, a character vector summarizing all
differences
}
\description{
Check difference of two liger command
}
\examples{
pbmc <- normalize(pbmc)
pbmc <- normalize(pbmc, log = TRUE, scaleFactor = 1e4)
cmds <- commands(pbmc)
commandDiff(pbmc, cmds[1], cmds[2])
}
