% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tramoseats.R
\name{tramo_forecast}
\alias{tramo_forecast}
\title{Forecasts with TRAMO}
\usage{
tramo_forecast(
  ts,
  spec = c("trfull", "tr0", "tr1", "tr2", "tr3", "tr4", "tr5"),
  nf = -1,
  context = NULL
)
}
\arguments{
\item{ts}{a univariate time series.}

\item{spec}{the model specification. Can be either the name of a predefined
specification or a user-defined specification.}

\item{nf}{the forecasting horizon (\code{numeric}). The forecast length is in
periods (positive values) or years (negative values). By default, the program
generates a one-year forecast (\code{nf = -1}).}

\item{context}{the dictionary of variables.}
}
\value{
a \code{mts} object with 7 variables:
\itemize{
\item \code{forecast} the forecast of the actual data at the end of the series.
\item \code{error} standard deviation of the forecast.
\item \code{fraw} the forecast of the transformed series.
\item \code{efraw} the standard deviation of the forecast of the transformed series.
}
}
\description{
Forecasts with TRAMO
}
\examples{
\dontshow{if (current_java_version >= minimal_java_version) withAutoprint(\{ # examplesIf}
\donttest{
tramo_forecast(rjd3toolkit::ABS$X0.2.09.10.M)
}
\dontshow{\}) # examplesIf}
}
