/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.api.tramo;

import jdplus.toolkit.base.api.timeseries.TimeSelector;
import jdplus.toolkit.base.api.util.Validatable;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class EstimateSpec
implements Validatable<EstimateSpec> {
    public static final double DEF_TOL = 1.0E-7;
    public static final double DEF_UBP = 0.96;
    public static final boolean DEF_EML = true;
    @NonNull
    private final TimeSelector span;
    private final boolean maximumLikelihood;
    private final double tol;
    private final double ubp;
    public static final EstimateSpec DEFAULT = (EstimateSpec)EstimateSpec.builder().build();

    public static Builder builder() {
        return new Builder().span(TimeSelector.all()).maximumLikelihood(true).tol(1.0E-7).ubp(0.96);
    }

    public boolean isDefault() {
        return this.equals(DEFAULT);
    }

    public EstimateSpec validate() throws IllegalArgumentException {
        if (this.tol <= 0.0 || this.tol > 0.01) {
            throw new IllegalArgumentException("Invalid Tol parameter");
        }
        return this;
    }

    @Generated
    EstimateSpec(@NonNull TimeSelector span, boolean maximumLikelihood, double tol, double ubp) {
        if (span == null) {
            throw new NullPointerException("span is marked non-null but is null");
        }
        this.span = span;
        this.maximumLikelihood = maximumLikelihood;
        this.tol = tol;
        this.ubp = ubp;
    }

    @Generated
    public @org.jspecify.annotations.NonNull Builder toBuilder() {
        return new Builder().span(this.span).maximumLikelihood(this.maximumLikelihood).tol(this.tol).ubp(this.ubp);
    }

    @NonNull
    @Generated
    public TimeSelector getSpan() {
        return this.span;
    }

    @Generated
    public boolean isMaximumLikelihood() {
        return this.maximumLikelihood;
    }

    @Generated
    public double getTol() {
        return this.tol;
    }

    @Generated
    public double getUbp() {
        return this.ubp;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EstimateSpec)) {
            return false;
        }
        EstimateSpec other = (EstimateSpec)o;
        if (this.isMaximumLikelihood() != other.isMaximumLikelihood()) {
            return false;
        }
        if (Double.compare(this.getTol(), other.getTol()) != 0) {
            return false;
        }
        if (Double.compare(this.getUbp(), other.getUbp()) != 0) {
            return false;
        }
        TimeSelector this$span = this.getSpan();
        TimeSelector other$span = other.getSpan();
        return !(this$span == null ? other$span != null : !this$span.equals(other$span));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isMaximumLikelihood() ? 79 : 97);
        long $tol = Double.doubleToLongBits(this.getTol());
        result = result * 59 + (int)($tol >>> 32 ^ $tol);
        long $ubp = Double.doubleToLongBits(this.getUbp());
        result = result * 59 + (int)($ubp >>> 32 ^ $ubp);
        TimeSelector $span = this.getSpan();
        result = result * 59 + ($span == null ? 43 : $span.hashCode());
        return result;
    }

    @Generated
    public @org.jspecify.annotations.NonNull String toString() {
        return "EstimateSpec(span=" + String.valueOf(this.getSpan()) + ", maximumLikelihood=" + this.isMaximumLikelihood() + ", tol=" + this.getTol() + ", ubp=" + this.getUbp() + ")";
    }

    public static class Builder
    implements Validatable.Builder<EstimateSpec> {
        @Generated
        private TimeSelector span;
        @Generated
        private boolean maximumLikelihood;
        @Generated
        private double tol;
        @Generated
        private double ubp;

        @Generated
        Builder() {
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder span(@NonNull TimeSelector span) {
            if (span == null) {
                throw new NullPointerException("span is marked non-null but is null");
            }
            this.span = span;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder maximumLikelihood(boolean maximumLikelihood) {
            this.maximumLikelihood = maximumLikelihood;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder tol(double tol) {
            this.tol = tol;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder ubp(double ubp) {
            this.ubp = ubp;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull EstimateSpec buildWithoutValidation() {
            return new EstimateSpec(this.span, this.maximumLikelihood, this.tol, this.ubp);
        }

        @Generated
        public @org.jspecify.annotations.NonNull String toString() {
            return "EstimateSpec.Builder(span=" + String.valueOf(this.span) + ", maximumLikelihood=" + this.maximumLikelihood + ", tol=" + this.tol + ", ubp=" + this.ubp + ")";
        }
    }
}

