/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.core.tramo;

import java.util.Optional;
import jdplus.toolkit.base.api.timeseries.regression.ModellingUtility;
import jdplus.toolkit.base.api.timeseries.regression.Variable;
import jdplus.toolkit.base.core.regarima.RegArimaModel;
import jdplus.toolkit.base.core.regsarima.regular.IRegressionModule;
import jdplus.toolkit.base.core.regsarima.regular.IRegressionTest;
import jdplus.toolkit.base.core.regsarima.regular.ModelDescription;
import jdplus.toolkit.base.core.regsarima.regular.ProcessingResult;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaModelling;
import jdplus.toolkit.base.core.regsarima.regular.TRegressionTest;
import jdplus.toolkit.base.core.stats.likelihood.ConcentratedLikelihoodWithMissing;

public class FastRegressionTest
implements IRegressionModule {
    public static final double CVAL = 1.96;
    private final IRegressionTest tdTest;
    private final IRegressionTest wdTest;
    private final IRegressionTest lpTest;
    private final IRegressionTest mhTest;
    private final IRegressionTest meanTest;

    public static Builder builder() {
        return new Builder();
    }

    private FastRegressionTest(Builder builder) {
        this.tdTest = new TRegressionTest(builder.tvar, builder.tvar);
        this.wdTest = new TRegressionTest(builder.tvar);
        this.lpTest = new TRegressionTest(builder.tvar);
        this.mhTest = new TRegressionTest(builder.tvar);
        this.meanTest = builder.testMean ? new TRegressionTest(builder.tmean) : null;
    }

    public ProcessingResult test(RegSarimaModelling context) {
        int pos;
        Variable variable;
        ModelDescription currentModel = context.getDescription();
        ModelDescription tmpModel = ModelDescription.copyOf((ModelDescription)currentModel);
        boolean changed = false;
        RegArimaModel regarima = tmpModel.regarima();
        ConcentratedLikelihoodWithMissing ll = context.getEstimation().getConcentratedLikelihood();
        int nhp = tmpModel.getArimaSpec().freeParametersCount();
        Optional<Variable> td = tmpModel.variables().filter(var -> ModellingUtility.isTradingDays((Variable)var) && ModellingUtility.isAutomaticallyIdentified((Variable)var)).findFirst();
        Optional<Variable> lp = tmpModel.variables().filter(var -> ModellingUtility.isLengthOfPeriod((Variable)var) && ModellingUtility.isAutomaticallyIdentified((Variable)var)).findFirst();
        Optional<Variable> easter = tmpModel.variables().filter(var -> ModellingUtility.isEaster((Variable)var) && ModellingUtility.isAutomaticallyIdentified((Variable)var)).findFirst();
        boolean removetd = false;
        if (td.isPresent()) {
            IRegressionTest test;
            variable = td.orElseThrow();
            pos = tmpModel.findPosition(variable.getCore());
            int dim = variable.getCore().dim();
            IRegressionTest iRegressionTest = test = dim == 1 ? this.wdTest : this.tdTest;
            if (!test.accept(ll, nhp, pos, dim)) {
                removetd = true;
            }
        }
        if (removetd && lp.isPresent()) {
            variable = lp.orElseThrow();
            pos = tmpModel.findPosition(variable.getCore());
            if (this.lpTest.accept(ll, nhp, pos, 1)) {
                removetd = false;
            } else {
                currentModel.remove(variable.getCore());
                changed = true;
            }
        }
        if (removetd) {
            currentModel.remove(td.orElseThrow().getCore());
            if (lp.isPresent()) {
                currentModel.remove(lp.orElseThrow().getCore());
            }
            changed = true;
        }
        if (easter.isPresent() && !this.mhTest.accept(ll, nhp, pos = tmpModel.findPosition((variable = easter.orElseThrow()).getCore()), 1)) {
            currentModel.remove(variable.getCore());
            changed = true;
        }
        if (this.meanTest != null && regarima.isMean() && !this.meanTest.accept(ll, nhp, 0, 1)) {
            currentModel.setMean(false);
            changed = true;
        }
        if (changed) {
            context.set(currentModel, null);
        }
        return changed ? ProcessingResult.Changed : ProcessingResult.Unchanged;
    }

    public static class Builder {
        private double tmean = 1.96;
        private double tvar = 1.96;
        private boolean testMean = true;

        public Builder meanThreshold(double tmean) {
            this.tmean = tmean;
            return this;
        }

        public Builder varThreshold(double tvar) {
            this.tvar = tvar;
            return this;
        }

        public Builder testMean(boolean test) {
            this.testMean = test;
            return this;
        }

        public FastRegressionTest build() {
            return new FastRegressionTest(this);
        }
    }
}

