/*
 * Decompiled with CFR 0.152.
 */
package internal.toolkit.base.core.math.functions.riso;

import internal.toolkit.base.core.math.functions.riso.Lbfgs;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.functions.FunctionMinimizer;
import jdplus.toolkit.base.core.math.functions.IFunction;
import jdplus.toolkit.base.core.math.functions.IFunctionDerivatives;
import jdplus.toolkit.base.core.math.functions.IFunctionPoint;
import jdplus.toolkit.base.core.math.functions.ParamValidation;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;

public class LbfgsMinimizer
implements FunctionMinimizer {
    private static final int MAX_FAILED = 20;
    private final double xtol;
    private final double gtol;
    private final int maxiter;
    private final double feps;
    private final int memory;
    private final Lbfgs lbfgs = new Lbfgs();
    private int nfailed;
    private IFunction fn;
    private IFunctionPoint fpt;
    private boolean converged;

    public static LbfgsBuilder builder() {
        return new LbfgsBuilder();
    }

    public LbfgsMinimizer(LbfgsBuilder builder) {
        this.xtol = builder.xtol;
        this.gtol = builder.gtol;
        this.feps = builder.feps;
        this.maxiter = builder.maxiter;
        this.memory = builder.memory;
    }

    @Override
    public FastMatrix curvatureAtMinimum() {
        return this.fpt.derivatives().hessian();
    }

    @Override
    public DoubleSeq gradientAtMinimum() {
        return this.fpt.derivatives().gradient();
    }

    public double getGTol() {
        return this.gtol;
    }

    @Override
    public int getIterationsCount() {
        return this.lbfgs.getNIter();
    }

    @Override
    public IFunctionPoint getResult() {
        return this.fpt;
    }

    @Override
    public double getObjective() {
        return this.fpt == null ? Double.NaN : this.fpt.getValue();
    }

    @Override
    public boolean minimize(IFunctionPoint start) {
        this.fn = start.getFunction();
        this.fpt = start;
        this.converged = false;
        DoubleSeq px = this.fpt.getParameters();
        int n = px.length();
        if (n == 0) {
            return true;
        }
        double[] x = new double[n];
        px.copyTo(x, 0);
        int[] iflag = new int[]{0};
        int[] iprint = new int[]{-1};
        double[] diag = new double[n];
        this.nfailed = 0;
        double fmin = this.fpt.getValue();
        double fprev = 0.0;
        double fcur = fmin;
        boolean failed = false;
        IFunctionDerivatives df = null;
        do {
            try {
                if (!failed) {
                    df = this.fpt.derivatives();
                }
                this.lbfgs.lbfgs(n, this.memory, x, failed ? 2.0 * Math.abs(fcur) : fcur, df.gradient().toArray(), false, diag, iprint, this.gtol, this.xtol, iflag);
                DataBlock rx = DataBlock.copyOf(x);
                if (iflag[0] == 0) {
                    this.fpt = this.fn.evaluate((DoubleSeq)rx);
                    break;
                }
                if (iflag[0] != 1) {
                    return false;
                }
                ParamValidation validation = this.fn.getDomain().validate(rx);
                if (validation == ParamValidation.Invalid) {
                    failed = true;
                    continue;
                }
                IFunctionPoint efn = this.fn.evaluate((DoubleSeq)rx);
                fcur = efn.getValue();
                if (fcur <= fmin) {
                    fprev = fmin;
                    fmin = fcur;
                    this.fpt = efn;
                    this.converged = Math.abs(fprev - fmin) < (1.0 + Math.abs(fmin)) * this.feps;
                }
                failed = false;
            }
            catch (RuntimeException ex) {
                failed = true;
            }
        } while (this.next(failed));
        return this.converged;
    }

    protected boolean next(boolean failed) {
        if (failed) {
            return this.nfailed++ <= 20;
        }
        this.nfailed = 0;
        return this.lbfgs.getNIter() <= this.maxiter && !this.converged;
    }

    public static class LbfgsBuilder
    implements FunctionMinimizer.Builder {
        private double xtol = 1.0E-9;
        private double gtol = 1.0E-5;
        private int maxiter = 100;
        private double feps = 1.0E-9;
        private int memory = 7;

        private LbfgsBuilder() {
        }

        @Override
        public LbfgsBuilder functionPrecision(double eps) {
            this.feps = eps;
            return this;
        }

        public LbfgsBuilder parametersPrecision(double eps) {
            this.xtol = eps;
            return this;
        }

        public LbfgsBuilder gradientPrecision(double eps) {
            this.gtol = eps;
            return this;
        }

        @Override
        public LbfgsBuilder maxIter(int niter) {
            this.maxiter = niter;
            return this;
        }

        public LbfgsBuilder memoryLength(int n) {
            this.memory = n;
            return this;
        }

        @Override
        public LbfgsMinimizer build() {
            return new LbfgsMinimizer(this);
        }
    }
}

