/*
 * Decompiled with CFR 0.152.
 */
package internal.io;

import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.io.FileParser;
import nbbrd.io.Resource;
import nbbrd.io.function.IOFunction;
import nbbrd.io.function.IOSupplier;

public final class DecodingFileParser<T>
implements FileParser<T> {
    @NonNull
    final FileParser<T> parser;
    @NonNull
    final IOFunction<InputStream, ? extends FilterInputStream> decoder;

    @Override
    @NonNull
    public T parseFile(@NonNull File source) throws IOException {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        return FileParser.super.parseFile(source);
    }

    @Override
    @NonNull
    public T parsePath(@NonNull Path source) throws IOException {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        return FileParser.super.parsePath(source);
    }

    @Override
    @NonNull
    public T parseResource(@NonNull Class<?> type, @NonNull String name) throws IOException {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return FileParser.super.parseResource(type, name);
    }

    @Override
    @NonNull
    public T parseStream(@NonNull IOSupplier<? extends InputStream> source) throws IOException {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        return FileParser.super.parseStream(source);
    }

    @Override
    @NonNull
    public T parseStream(@NonNull InputStream resource) throws IOException {
        if (resource == null) {
            throw new NullPointerException("resource is marked non-null but is null");
        }
        try (FilterInputStream decoding = this.decoder.applyWithIO(Resource.uncloseableInputStream(resource));){
            T t = this.parser.parseStream(decoding);
            return t;
        }
    }

    @Generated
    public DecodingFileParser(@NonNull FileParser<T> parser, @NonNull IOFunction<InputStream, ? extends FilterInputStream> decoder) {
        if (parser == null) {
            throw new NullPointerException("parser is marked non-null but is null");
        }
        if (decoder == null) {
            throw new NullPointerException("decoder is marked non-null but is null");
        }
        this.parser = parser;
        this.decoder = decoder;
    }
}

