% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rxp_inspect.R
\name{rxp_list_logs}
\alias{rxp_list_logs}
\title{List All Available Build Logs}
\usage{
rxp_list_logs(project_path = ".")
}
\arguments{
\item{project_path}{Character, defaults to ".".
Path to the root directory of the project.}
}
\value{
A data frame with log filenames, modification times, and file sizes.
}
\description{
Returns a data frame with information about all build logs
in the project's _rixpress directory.
}
\examples{
\dontrun{
  # List all build logs in the current project
  logs <- rxp_list_logs()

  # List logs from a specific project directory
  logs <- rxp_list_logs("path/to/project")
}
}
\seealso{
Other utilities: 
\code{\link{print.rxp_derivation}()},
\code{\link{rxp_check_chronicles}()},
\code{\link{rxp_copy}()},
\code{\link{rxp_gc}()},
\code{\link{rxp_init}()},
\code{\link{rxp_inspect}()},
\code{\link{rxp_load}()},
\code{\link{rxp_read}()},
\code{\link{rxp_trace}()}
}
\concept{utilities}
