% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_dag.R
\name{rxp_ggdag}
\alias{rxp_ggdag}
\title{Create a Directed Acyclic Graph (DAG) representing the pipeline
using \code{{ggplot2}}}
\usage{
rxp_ggdag(
  nodes_and_edges = get_nodes_edges(),
  color_by = c("pipeline", "type"),
  colour_by = NULL
)
}
\arguments{
\item{nodes_and_edges}{List, output of \code{get_nodes_edges()}.}

\item{color_by}{Character, either "pipeline" (default) or "type".
When "pipeline", nodes show type as fill colour and pipeline as border.
When "type", nodes are coloured entirely by derivation type (rxp_r, rxp_py, etc.).}

\item{colour_by}{Character, alias for \code{color_by}.}
}
\value{
A \code{{ggplot2}} object.
}
\description{
Uses \code{{ggdag}} to generate the plot. \code{{ggdag}} is a soft
dependency of \code{{rixpress}} so you need to install it to use this
function. When derivations are organized into pipelines using
\code{rxp_pipeline()}, nodes use a dual-encoding approach: the interior fill
shows the derivation type (R, Python, etc.) while a thick border shows
the pipeline group colour.
}
\examples{
\dontrun{
  rxp_ggdag()  # Dual encoding: fill = type, border = pipeline
  rxp_ggdag(color_by = "type")  # Color entirely by derivation type
}
}
\seealso{
Other visualisation functions: 
\code{\link{rxp_visnetwork}()}
}
\concept{visualisation functions}
