% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apps_of_direction.R
\name{plotmatbysurveylist}
\alias{plotmatbysurveylist}
\title{Plot Upstream Distance Between Observations of All Individuals}
\usage{
plotmatbysurveylist(matbysurveylist, type = "boxplot", showN = TRUE, ...)
}
\arguments{
\item{matbysurveylist}{A list of distance matrices returned from \link{matbysurveylist}.}

\item{type}{If \code{type} is set to \code{"boxplot"}, boxplots will be 
produced for each cell.  If \code{type} is set to \code{"confint"}, lines 
denoting an approximate 95 percent confidence interval for the mean will be 
produced instead.  If \code{type} is set to \code{"dotplot"}, a jittered
dotplot will be produced for each cell, which will be the most appropriate
if sample sizes are small.  Defaults to \code{"boxplot"}.}

\item{showN}{Whether to display the sample size for each cell.  Defaults to
TRUE.}

\item{...}{Additional plotting arguments.}
}
\description{
Produces a matrix of plots (boxplots are default), with plot \code{[i,j]} giving the
  distribution of upstream distances from observation \code{i} to observation
  \code{j}, for all individuals.
}
\note{
Building routes from the river mouth to each river network segment and/or distance lookup tables will
  greatly reduce computation time (see \link{buildsegroutes}).
}
\examples{
data(Gulk, smallset)
matbysurveylist <- matbysurveylist(unique=smallset$id, survey=smallset$flight, seg=smallset$seg, 
   vert=smallset$vert, rivers=Gulk)
plotmatbysurveylist(matbysurveylist)
plotmatbysurveylist(matbysurveylist,type="confint")
plotmatbysurveylist(matbysurveylist,type="dotplot")
   
data(fakefish)
# matbysurveylist <- matbysurveylist(unique=fakefish$fish.id, survey=fakefish$flight, 
#   seg=fakefish$seg, vert=fakefish$vert, rivers=Gulk)
# plotmatbysurveylist(matbysurveylist)
}
\seealso{
\link{upstream}, \link{upstreammatbysurvey}
}
\author{
Matt Tyers
}
