% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/B_ij_fun.R
\name{B_ij_fun}
\alias{B_ij_fun}
\title{Calculates B_ij: the functional contribution to dispersal probability I_ij}
\usage{
B_ij_fun(
  graph,
  field_B = "length",
  dir_distance_type = "symmetric",
  disp_type = "exponential",
  param_u,
  param_d,
  param,
  param_l
)
}
\arguments{
\item{graph}{an object of class igraph. Can be both directed or undirected.}

\item{field_B}{the 'graph' edge attribute to be used to calculate the distance. Default is \code{"length"}.}

\item{dir_distance_type}{how directionality in B_ij calculations is dealt with:
\code{"symmetric"} (i.e. undirected graph) or \code{"asymmetric"} (i.e. directed graph). See details.}

\item{disp_type}{the formula used to calculate the probabilities in the B_ij matrix.
Use \code{"exponential"} for exponential decay, \code{"threshold"} for setting a distance threshold,
or \code{"leptokurtic"} for leptokurtic dispersal.}

\item{param_u}{the upstream dispersal parameter. Must be a numeric value. Only used if \code{dir_distance_type = "asymmetric"}. See details.}

\item{param_d}{the downstream dispersal parameter. Must be a numeric value. Only used if \code{dir_distance_type = "asymmetric"}. See details.}

\item{param}{the dispersal parameter. Must be a numeric value. Only used if \code{dir_distance_type = "symmetric"}. See details.}

\item{param_l}{the parameters for the leptokurtic dispersal mode. Must be a numeric vector of the
type \code{c(sigma_stat, sigma_mob, p)}. See details below.}
}
\value{
a square matrix of size length(V(graph)) containing B_ij values.
The matrix is organized with "from" nodes on the columns and "to" nodes on the rows
}
\description{
Calculates B_ij: the functional contribution to dispersal probability I_ij
}
\details{
\code{dir_distance_type = "symmetric"} is to be used when the directionality of the river network is not relevant.
The distance between reaches midpoints is calculated for each couple of reaches.
\code{dir_distance_type = "asymmetric"} is to be used when the directionality is relevant.
The distance between reaches midpoints is calculated for each couple of reaches and splitted
between 'upstream travelled' distance and 'downstream travelled' distance.
When \code{disp_type ="leptokurtic"} is selected, symmetric dispersal is assumed.

The 'param_u', 'param_d', and 'param' values are interpreted differently based on the formula used to relate distance (d_ij) and probability (B_ij).
When \code{disp_type ="exponential"}, those values are used as the base of the exponential dispersal kernel: B_ij = param^d_ij.
When \code{disp_type ="threshold"}, those values are used to define the maximum dispersal length: B_ij = ifelse(d_ij < param, 1, 0).

When \code{disp_type ="leptokurtic"} is selected, a leptokurtic dispersal kernel is used to calculate B_ij.
A leptokurtic dispersal kernel is a mixture of two zero-centered gaussian distributions with standard deviations
\code{sigma_stat} (static part of the population), and \code{sigma_mob} (mobile part of the population).
The probability of dispersal is calculated as: B_ij = p F(0, sigma_stat, d_ij) + (1-p) F(0, sigma_mob, d_ij)
where F is the upper tail of the gaussian cumulative density function.
}
\examples{
library(igraph)
g <- igraph::graph_from_literal(1-+2, 2-+5, 3-+4, 4-+5, 6-+7, 7-+10, 8-+9, 9-+10,
5-+11, 11-+12, 10-+13, 13-+12, 12-+14, 14-+15, 15-+16)
E(g)$id_dam <- c("1", NA, "2", "3", NA, "4", NA, "5", "6", NA,  NA, NA, NA, "7", NA)
E(g)$type <- ifelse(is.na(E(g)$id_dam), "joint", "dam")
V(g)$length <- c(1, 1, 2, 3, 4, 1, 5, 1, 7, 7, 3, 2, 4, 5, 6, 9)
V(g)$HSI <- c(0.2, 0.1, 0.3, 0.4, 0.5, 0.5, 0.5, 0.6, 0.7, 0.8, 0.8, 0.8, 0.8, 0.8, 0.8, 0.8)
V(g)$Id <- V(g)$name
E(g)$pass_u <- E(g)$pass_d <- ifelse(!is.na(E(g)$id_dam),0.1,NA)
dist_mat <- B_ij_fun(g, param = 0.9)

}
