% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init_pal.R
\docType{data}
\name{pal_vir}
\alias{pal_vir}
\title{Alternative color palette using viridis colors.}
\format{
An object of class \code{character} of length 16.
}
\usage{
pal_vir
}
\description{
\code{pal_vir} is initialized to a vector of named elements (colors)
to define a scenario color scheme modeled on the \code{viridis} color scale.
}
\details{
These colors are select by the Matplotlib \code{viridis} color map
created by Stéfan van der Walt and Nathaniel Smith.
See the \code{viridisLite} package (maintained by Simon Garnier)
for further information.

Assign \code{pal <- pal_vir} to use as default color scheme
throughout the \bold{riskyr} package.
}
\examples{
pal_vir        # shows all color names and current values
pal_vir["hi"]  # shows the current color for hits (true positives, TP)
pal_vir["hi"] <- "green3" # defines a new color for hits (true positives, TP)

}
\seealso{
\code{\link{pal}} contains current color information;
\code{\link{init_pal}} initializes color information.

Other color palettes: 
\code{\link{pal_bw}},
\code{\link{pal_bwp}},
\code{\link{pal_crisk}},
\code{\link{pal_kn}},
\code{\link{pal_mbw}},
\code{\link{pal_mod}},
\code{\link{pal_org}},
\code{\link{pal_rgb}},
\code{\link{pal_unikn}}

Other lists containing current scenario information: 
\code{\link{accu}},
\code{\link{freq}},
\code{\link{num}},
\code{\link{pal}},
\code{\link{pal_bw}},
\code{\link{pal_bwp}},
\code{\link{pal_kn}},
\code{\link{pal_mbw}},
\code{\link{pal_mod}},
\code{\link{pal_org}},
\code{\link{pal_rgb}},
\code{\link{pal_unikn}},
\code{\link{prob}},
\code{\link{txt}},
\code{\link{txt_TF}},
\code{\link{txt_org}}
}
\concept{color palettes}
\concept{lists containing current scenario information}
\keyword{datasets}
