% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init_pal.R
\name{init_pal}
\alias{init_pal}
\title{Initialize basic color information.}
\usage{
init_pal(
  N_col = pal_def["N"],
  cond_true_col = pal_def["cond_true"],
  cond_false_col = pal_def["cond_false"],
  dec_pos_col = pal_def["dec_pos"],
  dec_neg_col = pal_def["dec_neg"],
  dec_cor_col = pal_def["dec_cor"],
  dec_err_col = pal_def["dec_err"],
  hi_col = pal_def["hi"],
  mi_col = pal_def["mi"],
  fa_col = pal_def["fa"],
  cr_col = pal_def["cr"],
  PPV_col = pal_def["ppv"],
  NPV_col = pal_def["npv"],
  txt_col = pal_def["txt"],
  bg_col = pal_def["bg"],
  brd_col = pal_def["brd"]
)
}
\arguments{
\item{N_col}{Color representing the \emph{population} of \code{\link{N}} cases or individuals.}

\item{cond_true_col}{Color representing cases of \code{\link{cond_true}}, for which the current condition is \code{TRUE}.}

\item{cond_false_col}{Color representing cases of in \code{\link{cond_false}}, for which the current condition is \code{FALSE}.}

\item{dec_pos_col}{Color representing cases of \code{\link{dec_pos}}, for which the current decision is \code{positive}.}

\item{dec_neg_col}{Color representing cases in \code{\link{dec_neg}}, for which the current decision is \code{negative}.}

\item{dec_cor_col}{Color representing cases of correct decisions \code{\link{dec_cor}}, for which the current decision is \code{accurate}.}

\item{dec_err_col}{Color representing cases in erroneous decisions \code{\link{dec_err}}, for which the current decision is \code{inaccurate}.}

\item{hi_col}{Color representing \emph{hits} or true positives in \code{\link{hi}}
(i.e., correct cases for which the current condition is TRUE and the decision is positive).}

\item{mi_col}{Color representing \emph{misses} or false negatives in \code{\link{mi}}
(i.e., incorrect cases for which the current condition is TRUE but the decision is negative).}

\item{fa_col}{Color representing \emph{false alarms} or false positives in \code{\link{fa}}
(i.e., incorrect cases for which the current condition is FALSE but the decision is positive).}

\item{cr_col}{Color representing \emph{correct rejections} or true negatives in \code{\link{cr}}
(i.e., correct cases for which the current condition is FALSE and the decision is negative).}

\item{PPV_col}{Color representing \emph{positive predictive values} \code{\link{PPV}} (i.e., the conditional probability that
the condition is TRUE, provided that the decision is positive).}

\item{NPV_col}{Color representing \emph{negative predictive values} \code{\link{NPV}} (i.e., the conditional probability that
the condition is FALSE, provided that the decision is negative).}

\item{txt_col}{Color used for text labels.}

\item{bg_col}{Background color of plot (used to set \code{par(bg = bg_col)}).}

\item{brd_col}{Color used for borders (e.g., around bars or boxes).}
}
\description{
\code{init_pal} initializes basic color information
(i.e., all colors corresponding to functional roles in
the current scenario and used throughout the \bold{riskyr} package).
}
\details{
All color information of the current scenario
is stored as named colors in a list \code{pal}.
\code{init_pal} allows changing colors by assigning
new colors to existing names.
}
\examples{
init_pal()          # => define and return a vector of current (default) colors
length(init_pal())  # => 15 named colors
pal <- init_pal(N_col = "steelblue4")  # => change a color (stored in pal)
pal <- init_pal(brd_col = NA)          # => remove a color

}
\seealso{
\code{\link{num}} contains basic numeric parameters;
\code{\link{init_num}} initializes basic numeric parameters;
\code{\link{txt}} contains current text information;
\code{\link{init_txt}} initializes text information;
\code{\link{pal}} contains current color information;
\code{\link{init_pal}} initializes color information;
\code{\link{freq}} contains current frequency information;
\code{\link{comp_freq}} computes current frequency information;
\code{\link{prob}} contains current probability information;
\code{\link{comp_prob}} computes current probability information.

Other functions initializing scenario information: 
\code{\link{init_num}()},
\code{\link{init_txt}()},
\code{\link{riskyr}()}
}
\concept{functions initializing scenario information}
