% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collections.R
\name{irm}
\alias{irm}
\title{Remove Data Objects or Collections in iRODS}
\usage{
irm(
  logical_path,
  force = TRUE,
  recursive = FALSE,
  catalog_only = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{logical_path}{Path to the data object or collection to remove.}

\item{force}{Whether the data object or collection should be deleted
permanently. If \code{FALSE}, it is sent to the trash collection. Defaults to
\code{TRUE}.}

\item{recursive}{If a collection is provided, whether its contents should
also be removed. If a collection is not empty and \code{recursive} is \code{FALSE}
, it cannot be deleted. Defaults to \code{FALSE}.}

\item{catalog_only}{Whether to remove only the catalog entry. Defaults to
\code{FALSE}.}

\item{verbose}{Whether information should be printed about the HTTP request
and response. Defaults to \code{FALSE}.}
}
\value{
Invisibly the HTTP call.
}
\description{
This is the equivalent of \code{\link[=file.remove]{file.remove()}}, but applied to an item inside
iRODS.
}
\examples{
\dontshow{if (is_irods_demo_running()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
is_irods_demo_running()
\dontshow{
.old_config_dir <- Sys.getenv("R_USER_CONFIG_DIR")
Sys.setenv("R_USER_CONFIG_DIR" = tempdir())
}
# connect project to server
\Sexpr[stage=build, results=rd]{paste0("create_irods(\"", rirods:::.irods_host, "\")")}

# authenticate
iauth("rods", "rods")

# some data
foo <- data.frame(x = c(1, 8, 9), y = c("x", "y", "z"))

# store
isaveRDS(foo, "foo.rds")

# check if file is stored
ils()

# delete object
irm("foo.rds", force = TRUE)

# check if file is deleted
ils()
\dontshow{
Sys.setenv("R_USER_CONFIG_DIR" = .old_config_dir)
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=imkdir]{imkdir()}} for creating collections,
\code{\link[=file.remove]{file.remove()}} for an R equivalent.
}
