% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-objects.R
\name{iget}
\alias{iget}
\alias{ireadRDS}
\title{Retrieve File or Object from iRODS}
\usage{
iget(
  logical_path,
  local_path,
  offset = 0,
  count = 0,
  verbose = FALSE,
  overwrite = FALSE,
  ticket = NULL
)

ireadRDS(logical_path, offset = 0, count = 0, verbose = FALSE, ticket = NULL)
}
\arguments{
\item{logical_path}{Source path in iRODS.}

\item{local_path}{Destination path in local storage. By default,
the basename of the logical path; the file will be stored in the current
directory (see \code{getwd()}).}

\item{offset}{Offset in bytes into the data object. Deprecated.}

\item{count}{Maximum number of bytes to write. Deprecated.}

\item{verbose}{Whether information should be printed about the HTTP request and response.}

\item{overwrite}{Whether the local file should be overwritten if it exists.
Defaults to \code{FALSE}.}

\item{ticket}{A valid iRODS ticket string. Defaults to \code{NULL}.}
}
\value{
The R object in case of \code{ireadRDS()}, invisibly \code{NULL} in case of
\code{iget()}.

The R object in case of \code{ireadRDS()}, invisibly \code{NULL} in case of \code{iget()}.
}
\description{
Transfer a file from iRODS to the local storage with \code{\link[=iget]{iget()}} or
read an R object from an RDS file in iRODS with \code{\link[=ireadRDS]{ireadRDS()}}
(see \code{\link[=readRDS]{readRDS()}}).
}
\examples{
\dontshow{if (is_irods_demo_running()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
is_irods_demo_running()
\dontshow{
.old_config_dir <- Sys.getenv("R_USER_CONFIG_DIR")
.old_wd <- setwd(tempdir())
Sys.setenv("R_USER_CONFIG_DIR" = tempdir())
}
# connect project to server
\Sexpr[stage=build, results=rd]{paste0("create_irods(\"", rirods:::.irods_host, "\")")}

# authenticate
iauth("rods", "rods")

# save the iris dataset as csv and send the file to iRODS
write.csv(iris, "iris.csv")
iput("iris.csv", "iris.csv")

# bring the file back with a different name
iget("iris.csv", "newer_iris.csv")
file.exists("newer_iris.csv") # check that it has been transferred

# send an R object to iRODS in RDS format
isaveRDS(iris, "irids_in_rds.rds")

# read it back
iris_again <- ireadRDS("irids_in_rds.rds")
iris_again

# delete objects in iRODS
irm("irids_in_rds.rds", force = TRUE)
irm("iris.csv", force = TRUE)

\dontshow{
setwd(.old_wd)
Sys.setenv("R_USER_CONFIG_DIR" = .old_config_dir)
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=iput]{iput()}} for sending files,
\code{\link[=isaveRDS]{isaveRDS()}} for sending R objects to iRODS,
\code{\link[=saveRDS]{saveRDS()}} for an R equivalent.

Transfer a file from iRODS to the local storage with \code{iget()} or
read an R object from an RDS file in iRODS with \code{ireadRDS()} (see \code{readRDS()}).
}
