% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/microwellPlates.R
\name{wellIndex2position}
\alias{wellIndex2position}
\title{Translate well index numbers to well positions}
\usage{
wellIndex2position(ind, format = c("96", "384"))
}
\arguments{
\item{ind}{Well index, integer numbers starting from 1, running rowwise. Non-integer parameters will be coereced to integers.}

\item{format}{Character string, well format}
}
\value{
A \code{data.frame} containing three columns: input \code{WellIndex}, \code{Row} (characters) and \code{Column} (integers)
}
\description{
Translate well index numbers to well positions
}
\examples{
wellIndex2position(1:96, format="96")
wellIndex2position(c(3,2,5,34,85, NA), format="96")
wellIndex2position(1:384, format="384")
}
