% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfmat.R
\name{applyTopOrIncAndNotExclFilter}
\alias{applyTopOrIncAndNotExclFilter}
\title{Apply isTopOrIncAndNotExcl filter to a matrix}
\usage{
applyTopOrIncAndNotExclFilter(matrix, MARGIN, top = 1, falseValue = 0, ...)
}
\arguments{
\item{matrix}{A matrix.}

\item{MARGIN}{Integer, 1 stands for row and 2 stands for column, passed to \code{apply}.}

\item{top}{Integer, how many top elements should be kept, passed to \code{isTopOrIncAndNotExcl}.}

\item{falseValue}{The same type as data in the matrix, used to replace values that is \code{FALSE} when judged by \code{isTopOrIncAndNotExcl}.}

\item{...}{Further parameters passed to \code{isTopOrIncAndNotExcl}, including \code{incFunc}, \code{excFunc}, and \code{decreasing}.
The function applies the filter function \code{isTopOrIncAndNotExcl} to each row or each column to a matrix, keeps the values that are \code{TRUE} based on the logical vector returned by function, and replaces the values that are \code{FALSE} with the value defined by \code{falseValue}.}
}
\value{
A matrix with the same dimnames but with elements not satisfying \code{isTopOrIncAndNotExcl} replaced by \code{falseValue}.
}
\description{
Apply isTopOrIncAndNotExcl filter to a matrix
}
\examples{
myMat <- matrix(c(1,2,3,4,8,7,6,5,12,9,11,10), nrow=3, byrow=TRUE,
   dimnames=list(c("A", "B", "C"), c("Alpha", "Beta", "Gamma", "Delta")))
print(myMat)
applyTopOrIncAndNotExclFilter(myMat, 1, top=2, falseValue=-1)
applyTopOrIncAndNotExclFilter(myMat, 2, top=2, falseValue=-1)
applyTopOrIncAndNotExclFilter(myMat, 2, top=2, falseValue=-1, decreasing=FALSE)
applyTopOrIncAndNotExclFilter(myMat, 1, top=2, falseValue=-1, incFunc=function(x) x\%\%2==0)
applyTopOrIncAndNotExclFilter(myMat, 1, top=2, falseValue=-1,
   incFunc=function(x) x\%\%2==0, excFunc=function(x) x<5)
}
