% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_cls.R
\name{is_factor_file}
\alias{is_factor_file}
\alias{is_cls_file}
\title{Check if a file encodes a factor}
\usage{
is_factor_file(con = stdin())

is_cls_file(con = stdin())
}
\arguments{
\item{con}{Connection from which to read the file}
}
\value{
Logical, \code{TRUE} if the file is a valid CLS factor file,
\code{FALSE} otherwise.
}
\description{
Check if a file encodes a factor
}
\examples{
set.seed(1887)
tempfac <- factor(sample(LETTERS, 30, replace=TRUE), levels=sample(LETTERS))
tempfile <- tempfile()
write_factor(tempfac, tempfile)
is_factor_file(tempfile)
write_factor(tempfac, tempfile, sep=" ")
is_factor_file(tempfile)
}
