% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bipartite_graph.R
\name{layout_as_bipartiteLR}
\alias{layout_as_bipartiteLR}
\title{Layout a bipartite graph from left to right}
\usage{
layout_as_bipartiteLR(g)
}
\arguments{
\item{g}{A \code{igraph} object}
}
\value{
A two-column matrix, the layout of the graph

The function simply calls \code{\link[igraph]{layout_as_bipartite}} and reverses the \code{X} and \code{Y} coordinates.
}
\description{
Layout a bipartite graph from left to right
}
\examples{
myDataFrame <- data.frame(Alpha=c("A", "E", "O", "U", "B", "D"), 
  Type=c("Vowel", "Vowel", "Vowel", "Vowel", "Consonance", "Consonance"))
myBpGraph <- bipartite_graph_from_data_frame(myDataFrame)
myLayout <- layout_as_bipartiteLR(myBpGraph)
}
