% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/incidence2bipartite.R
\name{incidence2bipartite}
\alias{incidence2bipartite}
\title{Build a bipartite graph with an incidence matrix}
\usage{
incidence2bipartite(
  matrix,
  size = c(12, 9),
  color = c("orange", "lightblue"),
  label.cex = c(1.1, 0.95),
  label.color = c("black", "navyblue"),
  V = list(),
  E = list(color = "black")
)
}
\arguments{
\item{matrix}{An incidence matrix}

\item{size}{A vector of length 2, size of nodes in rows and in columns}

\item{color}{A vector of length 2, color of nodes in rows and in columns}

\item{label.cex}{A vector of length 2, font size of labels of nodes
in rows and in columns}

\item{label.color}{A vector of length 2, color of labels of nodes
in rows and in columns}

\item{V}{A named list of other node styles, each item of length 1 or 2.  In the latter case, the first value is used for nodes in rows and the second for nodes in columns}

\item{E}{A named list of edge styles. Each item must be length of 1.}
}
\value{
An instance of \code{igraph} graph
}
\description{
Build a bipartite graph with an incidence matrix
}
\examples{
myIncMat <- matrix(c(0, 0, 1, 
  0, 1, 0,
  1, 0, 0,
  0, 1, 1,
  1, 1, 1),
  ncol=3, byrow=TRUE, dimnames=list(LETTERS[1:5], letters[1:3]))
myGraph <- incidence2bipartite(myIncMat,
  size=c(18,12),
  V=list(shape=c("rectangle", "circle"),
         frame.color="lightgray"))
if(requireNamespace("igraph")) {
  igraph::plot.igraph(myGraph)
}
}
