% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{analysis}
\alias{analysis}
\title{Analysis of the honeycomb selection design.}
\usage{
analysis(
  Main_Data_Frame = NULL,
  Response_Vector = NULL,
  circle = 6,
  blocks = FALSE,
  row_element = NULL,
  plant_element = NULL,
  CRS = NULL
)
}
\arguments{
\item{Main_Data_Frame}{A data frame generated by one of the functions HSD(), HSD0(), HSD01() and HSD03().}

\item{Response_Vector}{A vector containing the response variable data.}

\item{circle}{The number of plants per moving ring.}

\item{blocks}{The moving circular block.}

\item{row_element}{The position of the plant (number of row) in the center of a moving ring/circular block.}

\item{plant_element}{The position of the plant (number of plant) in the center of a moving ring/circular block.}

\item{CRS}{The number of selected plants used for the CRS index.}
}
\value{
A list.
}
\description{
This function analyzes the response variable of the data frame.
}
\examples{
main_data<-HSD(7,2,10,10,1)
main_data$Data<-wheat_data$total_yield

analysis(main_data,"Data",6)
}
\references{
Fasoula V. (2013). Prognostic Breeding: A New Paradigm for Crop Improvement. Plant Breeding Reviews 37: 297-347. 10.1002/9781118497869.ch6. \doi{10.1002/9781118497869.ch6}

Fasoula V.A., and Tokatlidis I.S. (2012). Development of crop cultivars by honeycomb breeding. Agronomy for Sustainable Development 32:161–180. 10.1007/s13593-011-0034-0 \doi{10.1007/s13593-011-0034-0}

Fasoulas A.C., and Fasoula V.A. (1995). Honeycomb selection designs. In J. Janick (ed.). Plant Breeding Reviews 13: 87-139.  \doi{10.1002/9780470650059.ch3}

Tokatlidis I. (2016). Sampling the spatial heterogeneity of the honeycomb model in maize and wheat breeding trials: Analysis of secondary data compared to popular classical designs. Experimental Agriculture, 52(3), 371-390. \doi{10.1017/S0014479715000150}

Tokatlidis I., and Vlachostergios D. (2016). Sustainable Stewardship of the Landrace Diversity. Diversity 8(4):29. \doi{10.3390/d8040029}
}
