% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_clusters_3.R
\name{split_clusters_3}
\alias{split_clusters_3}
\title{split_clusters_3}
\usage{
split_clusters_3(
  snp.object,
  partition,
  threshold = 1e-05,
  min.clust.size = 20,
  n.cores = 1
)
}
\arguments{
\item{snp.object}{A snp.object containing the processed SNP data.}

\item{partition}{An integer vector indicating an initial partition of the isolates.}

\item{threshold}{The increase in marginal log likelihood required to accept a move.}

\item{min.clust.size}{Clusters smaller than min.clust.size will not be split.}

\item{n.cores}{The number of cores to use.}
}
\value{
The best partition after splitting a cluster and re-allocating as well as
a boolean value indicating whether a move increased the marginal likelihood.
}
\description{
Peform an iteration of the third move in the algorithm. That is split cluster in two
and re-allocate one sub-cluster.
}
