% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gltfObj.R
\name{Gltf}
\alias{Gltf}
\title{R6 Class for glTF file objects}
\description{
The glTF file spec is described here: \url{https://registry.khronos.org/glTF/specs/2.0/glTF-2.0.html}.  This
object encapsulates most of the data from those files.
}
\examples{

## ------------------------------------------------
## Method `Gltf$print`
## ------------------------------------------------

\donttest{
samples <- "https://raw.githubusercontent.com/KhronosGroup/glTF-Sample-Models/master/2.0"
gltf <- readGLB(paste0(samples, "/2CylinderEngine/glTF-Binary/2CylinderEngine.glb?raw=true"))
gltf$print(names = "meshes")
}
}
\section{Super class}{
\code{\link[rgl:Buffer]{rgl::Buffer}} -> \code{gltf}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{scene}}{The default scene number}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-gltf-new}{\code{Gltf$new()}}
\item \href{#method-gltf-addAccessor}{\code{Gltf$addAccessor()}}
\item \href{#method-gltf-getScene}{\code{Gltf$getScene()}}
\item \href{#method-gltf-setScene}{\code{Gltf$setScene()}}
\item \href{#method-gltf-addScene}{\code{Gltf$addScene()}}
\item \href{#method-gltf-addToScene}{\code{Gltf$addToScene()}}
\item \href{#method-gltf-defaultScene}{\code{Gltf$defaultScene()}}
\item \href{#method-gltf-getNode}{\code{Gltf$getNode()}}
\item \href{#method-gltf-setNode}{\code{Gltf$setNode()}}
\item \href{#method-gltf-addNode}{\code{Gltf$addNode()}}
\item \href{#method-gltf-addChild}{\code{Gltf$addChild()}}
\item \href{#method-gltf-setParents}{\code{Gltf$setParents()}}
\item \href{#method-gltf-getSkin}{\code{Gltf$getSkin()}}
\item \href{#method-gltf-setSkin}{\code{Gltf$setSkin()}}
\item \href{#method-gltf-getJoint}{\code{Gltf$getJoint()}}
\item \href{#method-gltf-getInverseBindMatrices}{\code{Gltf$getInverseBindMatrices()}}
\item \href{#method-gltf-getForwardBindMatrices}{\code{Gltf$getForwardBindMatrices()}}
\item \href{#method-gltf-getCamera}{\code{Gltf$getCamera()}}
\item \href{#method-gltf-getExtras}{\code{Gltf$getExtras()}}
\item \href{#method-gltf-setExtras}{\code{Gltf$setExtras()}}
\item \href{#method-gltf-getMesh}{\code{Gltf$getMesh()}}
\item \href{#method-gltf-setMesh}{\code{Gltf$setMesh()}}
\item \href{#method-gltf-addMesh}{\code{Gltf$addMesh()}}
\item \href{#method-gltf-getMaterial}{\code{Gltf$getMaterial()}}
\item \href{#method-gltf-getTexture}{\code{Gltf$getTexture()}}
\item \href{#method-gltf-getImage}{\code{Gltf$getImage()}}
\item \href{#method-gltf-addMaterial}{\code{Gltf$addMaterial()}}
\item \href{#method-gltf-addTexture}{\code{Gltf$addTexture()}}
\item \href{#method-gltf-addImage}{\code{Gltf$addImage()}}
\item \href{#method-gltf-addSampler}{\code{Gltf$addSampler()}}
\item \href{#method-gltf-getMaterialNumber}{\code{Gltf$getMaterialNumber()}}
\item \href{#method-gltf-writeVectors}{\code{Gltf$writeVectors()}}
\item \href{#method-gltf-makePrimitive}{\code{Gltf$makePrimitive()}}
\item \href{#method-gltf-getAsset}{\code{Gltf$getAsset()}}
\item \href{#method-gltf-setAsset}{\code{Gltf$setAsset()}}
\item \href{#method-gltf-getTransform}{\code{Gltf$getTransform()}}
\item \href{#method-gltf-getRglMaterial}{\code{Gltf$getRglMaterial()}}
\item \href{#method-gltf-getAnimation}{\code{Gltf$getAnimation()}}
\item \href{#method-gltf-setAnimation}{\code{Gltf$setAnimation()}}
\item \href{#method-gltf-timerange}{\code{Gltf$timerange()}}
\item \href{#method-gltf-initAnimation}{\code{Gltf$initAnimation()}}
\item \href{#method-gltf-settime}{\code{Gltf$settime()}}
\item \href{#method-gltf-print}{\code{Gltf$print()}}
\item \href{#method-gltf-listCount}{\code{Gltf$listCount()}}
\item \href{#method-gltf-clone}{\code{Gltf$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="rgl" data-topic="Buffer" data-id="addBufferView"><a href='../../rgl/html/Buffer.html#method-Buffer-addBufferView'><code>rgl::Buffer$addBufferView()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgl" data-topic="Buffer" data-id="as.list"><a href='../../rgl/html/Buffer.html#method-Buffer-as.list'><code>rgl::Buffer$as.list()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgl" data-topic="Buffer" data-id="closeBuffer"><a href='../../rgl/html/Buffer.html#method-Buffer-closeBuffer'><code>rgl::Buffer$closeBuffer()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgl" data-topic="Buffer" data-id="closeBuffers"><a href='../../rgl/html/Buffer.html#method-Buffer-closeBuffers'><code>rgl::Buffer$closeBuffers()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgl" data-topic="Buffer" data-id="dataURI"><a href='../../rgl/html/Buffer.html#method-Buffer-dataURI'><code>rgl::Buffer$dataURI()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgl" data-topic="Buffer" data-id="getAccessor"><a href='../../rgl/html/Buffer.html#method-Buffer-getAccessor'><code>rgl::Buffer$getAccessor()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgl" data-topic="Buffer" data-id="getBuffer"><a href='../../rgl/html/Buffer.html#method-Buffer-getBuffer'><code>rgl::Buffer$getBuffer()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgl" data-topic="Buffer" data-id="getBufferview"><a href='../../rgl/html/Buffer.html#method-Buffer-getBufferview'><code>rgl::Buffer$getBufferview()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgl" data-topic="Buffer" data-id="load"><a href='../../rgl/html/Buffer.html#method-Buffer-load'><code>rgl::Buffer$load()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgl" data-topic="Buffer" data-id="openBuffer"><a href='../../rgl/html/Buffer.html#method-Buffer-openBuffer'><code>rgl::Buffer$openBuffer()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgl" data-topic="Buffer" data-id="openBufferview"><a href='../../rgl/html/Buffer.html#method-Buffer-openBufferview'><code>rgl::Buffer$openBufferview()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgl" data-topic="Buffer" data-id="readAccessor"><a href='../../rgl/html/Buffer.html#method-Buffer-readAccessor'><code>rgl::Buffer$readAccessor()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgl" data-topic="Buffer" data-id="readAccessor0"><a href='../../rgl/html/Buffer.html#method-Buffer-readAccessor0'><code>rgl::Buffer$readAccessor0()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgl" data-topic="Buffer" data-id="saveOpenBuffer"><a href='../../rgl/html/Buffer.html#method-Buffer-saveOpenBuffer'><code>rgl::Buffer$saveOpenBuffer()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgl" data-topic="Buffer" data-id="setAccessor"><a href='../../rgl/html/Buffer.html#method-Buffer-setAccessor'><code>rgl::Buffer$setAccessor()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgl" data-topic="Buffer" data-id="setBuffer"><a href='../../rgl/html/Buffer.html#method-Buffer-setBuffer'><code>rgl::Buffer$setBuffer()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgl" data-topic="Buffer" data-id="setBufferview"><a href='../../rgl/html/Buffer.html#method-Buffer-setBufferview'><code>rgl::Buffer$setBufferview()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgl" data-topic="Buffer" data-id="writeBuffer"><a href='../../rgl/html/Buffer.html#method-Buffer-writeBuffer'><code>rgl::Buffer$writeBuffer()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gltf-new"></a>}}
\if{latex}{\out{\hypertarget{method-gltf-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gltf$new(json = NULL, defaultbin = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{json}}{List read from glTF file.}

\item{\code{defaultbin}}{Optional external binary file.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gltf-addAccessor"></a>}}
\if{latex}{\out{\hypertarget{method-gltf-addAccessor}{}}}
\subsection{Method \code{addAccessor()}}{
Write values to accessor, including \code{min} and \code{max}.

The glTF standard requires \code{min} and \code{max} values in
accessors, whereas other uses of buffers may not.
This function stores in the usual way using the
\code{\link[rgl:Buffer]{Buffer$addAccessor()}} method, and then adds
\code{min} and \code{max} values.

The standard also doesn't support signed 4 byte integers
or double precision values, so we test for those here.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gltf$addAccessor(values, target = NULL, types = "anyGLTF", normalized = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{values}}{Values to write.}

\item{\code{target}}{Optional target use for values.}

\item{\code{types}}{Allowed types (from names of \code{rgl::gltfTypes}), or \code{c("any", "anyGLTF")}).}

\item{\code{normalized}}{Are these normalized
integer values?}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
New accessor number.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gltf-getScene"></a>}}
\if{latex}{\out{\hypertarget{method-gltf-getScene}{}}}
\subsection{Method \code{getScene()}}{
Get scene object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gltf$getScene(sc)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sc}}{Scene number.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Scene object, documented here:
\url{https://registry.khronos.org/glTF/specs/2.0/glTF-2.0.html#reference-scene}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gltf-setScene"></a>}}
\if{latex}{\out{\hypertarget{method-gltf-setScene}{}}}
\subsection{Method \code{setScene()}}{
Update scene record.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gltf$setScene(sc, scene)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sc}}{Which scene to update.}

\item{\code{scene}}{New scene record.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gltf-addScene"></a>}}
\if{latex}{\out{\hypertarget{method-gltf-addScene}{}}}
\subsection{Method \code{addScene()}}{
Add a scene object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gltf$addScene()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Scene number.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gltf-addToScene"></a>}}
\if{latex}{\out{\hypertarget{method-gltf-addToScene}{}}}
\subsection{Method \code{addToScene()}}{
Add node to scene.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gltf$addToScene(scene, node)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{scene}}{Scene number to modify.}

\item{\code{node}}{Node number(s) to add.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gltf-defaultScene"></a>}}
\if{latex}{\out{\hypertarget{method-gltf-defaultScene}{}}}
\subsection{Method \code{defaultScene()}}{
Get default scene, creating it if necessary.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gltf$defaultScene()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Scene number.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gltf-getNode"></a>}}
\if{latex}{\out{\hypertarget{method-gltf-getNode}{}}}
\subsection{Method \code{getNode()}}{
Get node object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gltf$getNode(n)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{Node number.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Node object, documented here:
\url{https://registry.khronos.org/glTF/specs/2.0/glTF-2.0.html#reference-node}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gltf-setNode"></a>}}
\if{latex}{\out{\hypertarget{method-gltf-setNode}{}}}
\subsection{Method \code{setNode()}}{
Set node object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gltf$setNode(n, node)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{Node number.}

\item{\code{node}}{New node object.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gltf-addNode"></a>}}
\if{latex}{\out{\hypertarget{method-gltf-addNode}{}}}
\subsection{Method \code{addNode()}}{
Add a node object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gltf$addNode(mesh = NULL, matrix = NULL, extras = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mesh}}{A mesh number.}

\item{\code{matrix}}{A matrix transformation for the node.}

\item{\code{extras}}{A list of extras, typically \code{rgl} objects.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Node number.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gltf-addChild"></a>}}
\if{latex}{\out{\hypertarget{method-gltf-addChild}{}}}
\subsection{Method \code{addChild()}}{
Add node as child of another.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gltf$addChild(parent, node)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{parent}}{Node number to modify.}

\item{\code{node}}{Node number(s) to add as children.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gltf-setParents"></a>}}
\if{latex}{\out{\hypertarget{method-gltf-setParents}{}}}
\subsection{Method \code{setParents()}}{
Set parent member for all nodes
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gltf$setParents()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gltf-getSkin"></a>}}
\if{latex}{\out{\hypertarget{method-gltf-getSkin}{}}}
\subsection{Method \code{getSkin()}}{
Get skin object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gltf$getSkin(skin)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{skin}}{Skin number.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Skin object, documented here:
\url{https://registry.khronos.org/glTF/specs/2.0/glTF-2.0.html#reference-skin}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gltf-setSkin"></a>}}
\if{latex}{\out{\hypertarget{method-gltf-setSkin}{}}}
\subsection{Method \code{setSkin()}}{
Set skin object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gltf$setSkin(n, skin)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{Skin number.}

\item{\code{skin}}{New skin object.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gltf-getJoint"></a>}}
\if{latex}{\out{\hypertarget{method-gltf-getJoint}{}}}
\subsection{Method \code{getJoint()}}{
Get joint node.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gltf$getJoint(skin, num)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{skin}}{Skin number.}

\item{\code{num}}{Joint number.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Node object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gltf-getInverseBindMatrices"></a>}}
\if{latex}{\out{\hypertarget{method-gltf-getInverseBindMatrices}{}}}
\subsection{Method \code{getInverseBindMatrices()}}{
Get "inverse bind matrices".

These matrices undo the existing
transformation before applying the skin
transformations.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gltf$getInverseBindMatrices(skin)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{skin}}{Skin number.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A 4x4xn array of matrices, one per joint.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gltf-getForwardBindMatrices"></a>}}
\if{latex}{\out{\hypertarget{method-gltf-getForwardBindMatrices}{}}}
\subsection{Method \code{getForwardBindMatrices()}}{
Get "forward bind matrices".

These matrices applying the skin
transformations.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gltf$getForwardBindMatrices(skin)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{skin}}{Skin number.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A 4x4xn array of matrices, one per joint.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gltf-getCamera"></a>}}
\if{latex}{\out{\hypertarget{method-gltf-getCamera}{}}}
\subsection{Method \code{getCamera()}}{
Get camera object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gltf$getCamera(cam)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{cam}}{Camera number.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Camera object, documented here:
\url{https://registry.khronos.org/glTF/specs/2.0/glTF-2.0.html#reference-camera}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gltf-getExtras"></a>}}
\if{latex}{\out{\hypertarget{method-gltf-getExtras}{}}}
\subsection{Method \code{getExtras()}}{
Get top-level extras list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gltf$getExtras()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Extras list, including rgl objects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gltf-setExtras"></a>}}
\if{latex}{\out{\hypertarget{method-gltf-setExtras}{}}}
\subsection{Method \code{setExtras()}}{
Set extras list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gltf$setExtras(extras)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{extras}}{New extras list.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gltf-getMesh"></a>}}
\if{latex}{\out{\hypertarget{method-gltf-getMesh}{}}}
\subsection{Method \code{getMesh()}}{
Get mesh object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gltf$getMesh(m)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{m}}{Mesh number.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Mesh object, documented here:
\url{https://registry.khronos.org/glTF/specs/2.0/glTF-2.0.html#reference-mesh}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gltf-setMesh"></a>}}
\if{latex}{\out{\hypertarget{method-gltf-setMesh}{}}}
\subsection{Method \code{setMesh()}}{
Set mesh object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gltf$setMesh(m, mesh)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{m}}{Mesh number.}

\item{\code{mesh}}{New mesh object}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gltf-addMesh"></a>}}
\if{latex}{\out{\hypertarget{method-gltf-addMesh}{}}}
\subsection{Method \code{addMesh()}}{
Add a mesh object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gltf$addMesh(primitives)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{primitives}}{A list of primitive objects.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Mesh number.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gltf-getMaterial"></a>}}
\if{latex}{\out{\hypertarget{method-gltf-getMaterial}{}}}
\subsection{Method \code{getMaterial()}}{
Get material object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gltf$getMaterial(m)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{m}}{Material number.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Material object, documented here:
\url{https://registry.khronos.org/glTF/specs/2.0/glTF-2.0.html#reference-material}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gltf-getTexture"></a>}}
\if{latex}{\out{\hypertarget{method-gltf-getTexture}{}}}
\subsection{Method \code{getTexture()}}{
Get texture object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gltf$getTexture(tex)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tex}}{Texture number.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Texture object, documented here:
\url{https://registry.khronos.org/glTF/specs/2.0/glTF-2.0.html#reference-texture}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gltf-getImage"></a>}}
\if{latex}{\out{\hypertarget{method-gltf-getImage}{}}}
\subsection{Method \code{getImage()}}{
Get image object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gltf$getImage(im)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{im}}{Image number.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Image object, documented here:
\url{https://registry.khronos.org/glTF/specs/2.0/glTF-2.0.html#reference-image}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gltf-addMaterial"></a>}}
\if{latex}{\out{\hypertarget{method-gltf-addMaterial}{}}}
\subsection{Method \code{addMaterial()}}{
Construct and possibly add material.

This will return an existing material if possible.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gltf$addMaterial(mat, defaultMaterial = list())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mat}}{An \code{rgl} material record.}

\item{\code{defaultMaterial}}{Default material properties.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Material number.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gltf-addTexture"></a>}}
\if{latex}{\out{\hypertarget{method-gltf-addTexture}{}}}
\subsection{Method \code{addTexture()}}{
Add a texture.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gltf$addTexture(mat)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mat}}{An \code{rgl} material record.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Texture number.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gltf-addImage"></a>}}
\if{latex}{\out{\hypertarget{method-gltf-addImage}{}}}
\subsection{Method \code{addImage()}}{
Add an image for a texture.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gltf$addImage(mat)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mat}}{An \code{rgl} material record.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Image number.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gltf-addSampler"></a>}}
\if{latex}{\out{\hypertarget{method-gltf-addSampler}{}}}
\subsection{Method \code{addSampler()}}{
Add a sampler.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gltf$addSampler(mat)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mat}}{An \code{rgl} material record.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Sampler number.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gltf-getMaterialNumber"></a>}}
\if{latex}{\out{\hypertarget{method-gltf-getMaterialNumber}{}}}
\subsection{Method \code{getMaterialNumber()}}{
Add or return a material.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gltf$getMaterialNumber(material)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{material}}{A glTF material record.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Material number.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gltf-writeVectors"></a>}}
\if{latex}{\out{\hypertarget{method-gltf-writeVectors}{}}}
\subsection{Method \code{writeVectors()}}{
Write data.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gltf$writeVectors(
  coords,
  target = targetArray,
  types = "anyGLTF",
  normalized = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{coords}}{Data to write, or \code{NULL}.}

\item{\code{target}}{Optional target use for data.}

\item{\code{types}}{A character vector of allowed types, or "any" or "anyGLTF"}

\item{\code{normalized}}{Are these integer values representing floats?}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Accessor number, or \code{NULL}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gltf-makePrimitive"></a>}}
\if{latex}{\out{\hypertarget{method-gltf-makePrimitive}{}}}
\subsection{Method \code{makePrimitive()}}{
Create a primitive record.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gltf$makePrimitive(inds, mode = NULL, attributes = NULL, matnum = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{inds}}{Indices of vertices.}

\item{\code{mode}}{Mode of primitive.}

\item{\code{attributes}}{Primitive attributes.}

\item{\code{matnum}}{Material number.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Primitive record, documented here:
\url{https://registry.khronos.org/glTF/specs/2.0/glTF-2.0.html#reference-primitive}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gltf-getAsset"></a>}}
\if{latex}{\out{\hypertarget{method-gltf-getAsset}{}}}
\subsection{Method \code{getAsset()}}{
Get asset list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gltf$getAsset()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Asset object, documented here:
\url{https://registry.khronos.org/glTF/specs/2.0/glTF-2.0.html#reference-asset}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gltf-setAsset"></a>}}
\if{latex}{\out{\hypertarget{method-gltf-setAsset}{}}}
\subsection{Method \code{setAsset()}}{
Set asset list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gltf$setAsset(version, generator)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{version}}{Version number of glTF format.}

\item{\code{generator}}{Identifier of code generating it.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gltf-getTransform"></a>}}
\if{latex}{\out{\hypertarget{method-gltf-getTransform}{}}}
\subsection{Method \code{getTransform()}}{
Get local transform.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gltf$getTransform(n)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{Node number.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
4x4 matrix of local transform.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gltf-getRglMaterial"></a>}}
\if{latex}{\out{\hypertarget{method-gltf-getRglMaterial}{}}}
\subsection{Method \code{getRglMaterial()}}{
Reconstruct \code{rgl} material.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gltf$getRglMaterial(n)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{Material number.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{rgl} material record.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gltf-getAnimation"></a>}}
\if{latex}{\out{\hypertarget{method-gltf-getAnimation}{}}}
\subsection{Method \code{getAnimation()}}{
Get animation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gltf$getAnimation(ani)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ani}}{Animation number}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Animation object, documented here:
\url{https://registry.khronos.org/glTF/specs/2.0/glTF-2.0.html#reference-animation}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gltf-setAnimation"></a>}}
\if{latex}{\out{\hypertarget{method-gltf-setAnimation}{}}}
\subsection{Method \code{setAnimation()}}{
Set animation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gltf$setAnimation(ani, animation)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ani}}{Animation number}

\item{\code{animation}}{New animation object}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gltf-timerange"></a>}}
\if{latex}{\out{\hypertarget{method-gltf-timerange}{}}}
\subsection{Method \code{timerange()}}{
Find time range of an animation
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gltf$timerange(ani)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ani}}{Animation number}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Min and max times from the samplers in the animation.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gltf-initAnimation"></a>}}
\if{latex}{\out{\hypertarget{method-gltf-initAnimation}{}}}
\subsection{Method \code{initAnimation()}}{
Initialize animation.

This builds all of the interpolation functions
in the samplers.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gltf$initAnimation(ani)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ani}}{Animation number}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Modified animation object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gltf-settime"></a>}}
\if{latex}{\out{\hypertarget{method-gltf-settime}{}}}
\subsection{Method \code{settime()}}{
Set time for an animation.

This evaluates all the interpolators and modifies
self to reflect the specified time point.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gltf$settime(time, ani = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{time}}{Time to set.}

\item{\code{ani}}{Animation number.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Vector of node numbers that were changed.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gltf-print"></a>}}
\if{latex}{\out{\hypertarget{method-gltf-print}{}}}
\subsection{Method \code{print()}}{
Print \code{gltf} objects with various levels of detail.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gltf$print(verbose = FALSE, names = FALSE, showExtras = TRUE, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{verbose}}{Logical indicator of verbose printing, or
character vector of components to print verbosely.}

\item{\code{names}}{Print names for components.}

\item{\code{showExtras}}{Logical:  show extra fields?}

\item{\code{...}}{Passed \code{...} .}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
samples <- "https://raw.githubusercontent.com/KhronosGroup/glTF-Sample-Models/master/2.0"
gltf <- readGLB(paste0(samples, "/2CylinderEngine/glTF-Binary/2CylinderEngine.glb?raw=true"))
gltf$print(names = "meshes")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gltf-listCount"></a>}}
\if{latex}{\out{\hypertarget{method-gltf-listCount}{}}}
\subsection{Method \code{listCount()}}{
Get number of items in private list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gltf$listCount(list)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{list}}{Name of list to get.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gltf-clone"></a>}}
\if{latex}{\out{\hypertarget{method-gltf-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gltf$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
