% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/special-orthogonal.R
\name{SpecialOrthogonalVectors}
\alias{SpecialOrthogonalVectors}
\title{Abstract Class for Special Orthogonal Groups in Vector Representation}
\description{
Class for the special orthogonal groups
\eqn{\mathrm{SO}(\{2,3\})} in vector form, i.e. the Lie groups of planar
and 3D rotations. This class is specific to the vector representation of
rotations. For the matrix representation, use the \code{\link{SpecialOrthogonal}}
class and set \code{n = 2} or \code{n = 3}.
}
\examples{

## ------------------------------------------------
## Method `SpecialOrthogonalVectors$projection`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  so2 <- SpecialOrthogonal(n = 2, point_type = "vector")
  so2$projection(diag(1, 2))
}

## ------------------------------------------------
## Method `SpecialOrthogonalVectors$skew_matrix_from_vector`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  so2 <- SpecialOrthogonal(n = 2, point_type = "vector")
  so2$skew_matrix_from_vector(array(0))
}

## ------------------------------------------------
## Method `SpecialOrthogonalVectors$vector_from_skew_matrix`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  so2 <- SpecialOrthogonal(n = 2, point_type = "vector")
  so2$vector_from_skew_matrix(diag(0, 2))
}

## ------------------------------------------------
## Method `SpecialOrthogonalVectors$regularize_tangent_vec_at_identity`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  so2 <- SpecialOrthogonal(n = 2, point_type = "vector")
  so2$regularize_tangent_vec_at_identity(array(0))
}

## ------------------------------------------------
## Method `SpecialOrthogonalVectors$regularize_tangent_vec`
## ------------------------------------------------

if (reticulate::py_module_available("geomstats")) {
  so2 <- SpecialOrthogonal(n = 2, point_type = "vector")
  so2$regularize_tangent_vec(array(0), array(1))
}
}
\author{
Nicolas Guigui and Nina Miolane
}
\keyword{internal}
\section{Super classes}{
\code{rgeomstats::PythonClass} -> \code{\link[rgeomstats:Manifold]{rgeomstats::Manifold}} -> \code{\link[rgeomstats:LieGroup]{rgeomstats::LieGroup}} -> \code{SpecialOrthogonalVectors}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{n}}{An integer value specifying the number of rows and columns of
the matrices.}

\item{\code{epsilon}}{A numeric value specifying the precision to use for
calculations involving potential divison by 0 in rotations.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-SpecialOrthogonalVectors-new}{\code{SpecialOrthogonalVectors$new()}}
\item \href{#method-SpecialOrthogonalVectors-projection}{\code{SpecialOrthogonalVectors$projection()}}
\item \href{#method-SpecialOrthogonalVectors-skew_matrix_from_vector}{\code{SpecialOrthogonalVectors$skew_matrix_from_vector()}}
\item \href{#method-SpecialOrthogonalVectors-vector_from_skew_matrix}{\code{SpecialOrthogonalVectors$vector_from_skew_matrix()}}
\item \href{#method-SpecialOrthogonalVectors-regularize_tangent_vec_at_identity}{\code{SpecialOrthogonalVectors$regularize_tangent_vec_at_identity()}}
\item \href{#method-SpecialOrthogonalVectors-regularize_tangent_vec}{\code{SpecialOrthogonalVectors$regularize_tangent_vec()}}
\item \href{#method-SpecialOrthogonalVectors-clone}{\code{SpecialOrthogonalVectors$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="PythonClass" data-id="get_python_class"><a href='../../rgeomstats/html/PythonClass.html#method-PythonClass-get_python_class'><code>rgeomstats::PythonClass$get_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="PythonClass" data-id="set_python_class"><a href='../../rgeomstats/html/PythonClass.html#method-PythonClass-set_python_class'><code>rgeomstats::PythonClass$set_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="belongs"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-belongs'><code>rgeomstats::Manifold$belongs()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="is_tangent"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-is_tangent'><code>rgeomstats::Manifold$is_tangent()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="random_point"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-random_point'><code>rgeomstats::Manifold$random_point()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="random_tangent_vec"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-random_tangent_vec'><code>rgeomstats::Manifold$random_tangent_vec()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="regularize"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-regularize'><code>rgeomstats::Manifold$regularize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="set_metric"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-set_metric'><code>rgeomstats::Manifold$set_metric()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="Manifold" data-id="to_tangent"><a href='../../rgeomstats/html/Manifold.html#method-Manifold-to_tangent'><code>rgeomstats::Manifold$to_tangent()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="LieGroup" data-id="add_metric"><a href='../../rgeomstats/html/LieGroup.html#method-LieGroup-add_metric'><code>rgeomstats::LieGroup$add_metric()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="LieGroup" data-id="compose"><a href='../../rgeomstats/html/LieGroup.html#method-LieGroup-compose'><code>rgeomstats::LieGroup$compose()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="LieGroup" data-id="exp"><a href='../../rgeomstats/html/LieGroup.html#method-LieGroup-exp'><code>rgeomstats::LieGroup$exp()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="LieGroup" data-id="exp_from_identity"><a href='../../rgeomstats/html/LieGroup.html#method-LieGroup-exp_from_identity'><code>rgeomstats::LieGroup$exp_from_identity()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="LieGroup" data-id="exp_not_from_identity"><a href='../../rgeomstats/html/LieGroup.html#method-LieGroup-exp_not_from_identity'><code>rgeomstats::LieGroup$exp_not_from_identity()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="LieGroup" data-id="get_identity"><a href='../../rgeomstats/html/LieGroup.html#method-LieGroup-get_identity'><code>rgeomstats::LieGroup$get_identity()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="LieGroup" data-id="inverse"><a href='../../rgeomstats/html/LieGroup.html#method-LieGroup-inverse'><code>rgeomstats::LieGroup$inverse()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="LieGroup" data-id="jacobian_translation"><a href='../../rgeomstats/html/LieGroup.html#method-LieGroup-jacobian_translation'><code>rgeomstats::LieGroup$jacobian_translation()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="LieGroup" data-id="lie_bracket"><a href='../../rgeomstats/html/LieGroup.html#method-LieGroup-lie_bracket'><code>rgeomstats::LieGroup$lie_bracket()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="LieGroup" data-id="log"><a href='../../rgeomstats/html/LieGroup.html#method-LieGroup-log'><code>rgeomstats::LieGroup$log()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="LieGroup" data-id="log_from_identity"><a href='../../rgeomstats/html/LieGroup.html#method-LieGroup-log_from_identity'><code>rgeomstats::LieGroup$log_from_identity()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="LieGroup" data-id="log_not_from_identity"><a href='../../rgeomstats/html/LieGroup.html#method-LieGroup-log_not_from_identity'><code>rgeomstats::LieGroup$log_not_from_identity()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgeomstats" data-topic="LieGroup" data-id="tangent_translation_map"><a href='../../rgeomstats/html/LieGroup.html#method-LieGroup-tangent_translation_map'><code>rgeomstats::LieGroup$tangent_translation_map()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SpecialOrthogonalVectors-new"></a>}}
\if{latex}{\out{\hypertarget{method-SpecialOrthogonalVectors-new}{}}}
\subsection{Method \code{new()}}{
The \code{\link{SpecialOrthogonalVectors}} class constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SpecialOrthogonalVectors$new(n, epsilon = 0, py_cls = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{An integer value specifying the number of rows and columns of
the matrices.}

\item{\code{epsilon}}{A numeric value specifying the precision to use for
calculations involving potential divison by 0 in rotations. Defaults to
\code{0}.}

\item{\code{py_cls}}{A Python object of class \code{SpecialOrthogonalVectors}.
Defaults to \code{NULL} in which case it is instantiated on the fly using
the other input arguments.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of class \code{\link{SpecialOrthogonalVectors}}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SpecialOrthogonalVectors-projection"></a>}}
\if{latex}{\out{\hypertarget{method-SpecialOrthogonalVectors-projection}{}}}
\subsection{Method \code{projection()}}{
Projects a matrix on \eqn{\mathrm{SO}(2)} or
\eqn{\mathrm{SO}(3)} using the Frobenius norm.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SpecialOrthogonalVectors$projection(point)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{point}}{A numeric array of shape \eqn{[\dots \times n \times n]}
specifying one or more matrices to be projected.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric array of the same shape as the input point storing the
projected matrices.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  so2 <- SpecialOrthogonal(n = 2, point_type = "vector")
  so2$projection(diag(1, 2))
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SpecialOrthogonalVectors-skew_matrix_from_vector"></a>}}
\if{latex}{\out{\hypertarget{method-SpecialOrthogonalVectors-skew_matrix_from_vector}{}}}
\subsection{Method \code{skew_matrix_from_vector()}}{
Gets the skew-symmetric matrix derived from the vector. In
3D, computes the skew-symmetric matrix, known as the cross-product of a
vector, associated to the vector \code{vec}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SpecialOrthogonalVectors$skew_matrix_from_vector(vec)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{vec}}{A numeric array of shape \eqn{[\dots \times \mathrm{dim}]}
specifying one or more vectors from which to compute corresponding skew
matrix representations.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric array of shape \eqn{[\dots \times n \times n]} storing
the corresponding skew matrix representations.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  so2 <- SpecialOrthogonal(n = 2, point_type = "vector")
  so2$skew_matrix_from_vector(array(0))
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SpecialOrthogonalVectors-vector_from_skew_matrix"></a>}}
\if{latex}{\out{\hypertarget{method-SpecialOrthogonalVectors-vector_from_skew_matrix}{}}}
\subsection{Method \code{vector_from_skew_matrix()}}{
Derives a vector from the skew-symmetric matrix. In 3D,
computes the vector defining the cross-product associated to a
skew-symmetric matrix.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SpecialOrthogonalVectors$vector_from_skew_matrix(skew_mat)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{skew_mat}}{A numeric array of shape \eqn{[\dots \times n \times n]}
specifying skew matrices.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric array of shape \eqn{[\dots \times \mathrm{dim}]}
storing the corresponding vector representations.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  so2 <- SpecialOrthogonal(n = 2, point_type = "vector")
  so2$vector_from_skew_matrix(diag(0, 2))
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SpecialOrthogonalVectors-regularize_tangent_vec_at_identity"></a>}}
\if{latex}{\out{\hypertarget{method-SpecialOrthogonalVectors-regularize_tangent_vec_at_identity}{}}}
\subsection{Method \code{regularize_tangent_vec_at_identity()}}{
Regularizes a tangent vector at the identity. In 2D,
regularizes a tangent vector by getting its norm at the identity to be
less than \eqn{\pi}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SpecialOrthogonalVectors$regularize_tangent_vec_at_identity(
  tangent_vec,
  metric = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tangent_vec}}{A numeric array of shape \eqn{[\dots \times 1]}
specifying one or more tangent vectors at base point.}

\item{\code{metric}}{An object of class \code{\link{RiemannianMetric}} specifying the
metric to compute the norm of the tangent vector or \code{NULL}. If it is
set to \code{NULL}, it defaults to using the Euclidean metric.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric array of shape \eqn{[\dots \times 1]} storing the
regularized tangent vector(s).
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  so2 <- SpecialOrthogonal(n = 2, point_type = "vector")
  so2$regularize_tangent_vec_at_identity(array(0))
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SpecialOrthogonalVectors-regularize_tangent_vec"></a>}}
\if{latex}{\out{\hypertarget{method-SpecialOrthogonalVectors-regularize_tangent_vec}{}}}
\subsection{Method \code{regularize_tangent_vec()}}{
Regularizes a tangent vector at a base point. In 2D,
regularizes a tangent vector by getting the norm of its parallel
transport to the identity, determined by the metric, to be less than
\eqn{\pi}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SpecialOrthogonalVectors$regularize_tangent_vec(
  tangent_vec,
  base_point,
  metric = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tangent_vec}}{A numeric array of shape \eqn{[\dots \times 1]}
specifying one or more tangent vectors at corresponding base points.}

\item{\code{base_point}}{A numeric array of shape \eqn{[\dots \times 1]}
specifying one or more points on the manifold.}

\item{\code{metric}}{An object of class \code{\link{RiemannianMetric}} specifying the
metric to compute the norm of the tangent vector or \code{NULL}. If it is
set to \code{NULL}, it defaults to using the Euclidean metric.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A numeric array of shape \eqn{[\dots \times 1]} storing the
regularized tangent vector(s).
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (reticulate::py_module_available("geomstats")) {
  so2 <- SpecialOrthogonal(n = 2, point_type = "vector")
  so2$regularize_tangent_vec(array(0), array(1))
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SpecialOrthogonalVectors-clone"></a>}}
\if{latex}{\out{\hypertarget{method-SpecialOrthogonalVectors-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SpecialOrthogonalVectors$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
