% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rfm-plots.R
\name{rfm_plot_order_dist}
\alias{rfm_plot_order_dist}
\alias{rfm_order_dist}
\title{Customers by orders}
\usage{
rfm_plot_order_dist(
  rfm_table,
  flip = FALSE,
  bar_color = NULL,
  plot_title = NULL,
  xaxis_label = NULL,
  yaxis_label = NULL,
  bar_label_size = 3,
  bar_labels = TRUE,
  interactive = FALSE,
  animate = FALSE,
  print_plot = TRUE
)
}
\arguments{
\item{rfm_table}{An object of class \code{rfm_table}.}

\item{flip}{logical; if \code{TRUE}, creates horizontal bar plot.}

\item{bar_color}{Color of the bars.}

\item{plot_title}{Title of the plot.}

\item{xaxis_label}{X axis title.}

\item{yaxis_label}{Y axis title.}

\item{bar_label_size}{Size of bar labels.}

\item{bar_labels}{If \code{TRUE}, add labels to the bars. Defaults to
\code{TRUE}.}

\item{interactive}{If \code{TRUE}, uses \code{plotly} as the visualization
engine. If \code{FALSE}, uses \code{ggplot2}.}

\item{animate}{If \code{TRUE}, animates the bars. Defaults to \code{FALSE}.}

\item{print_plot}{logical; if \code{TRUE}, prints the plot else returns a
plot object.}
}
\value{
Bar chart.
}
\description{
Visualize the distribution of customers across orders.
}
\section{Deprecated Functions}{

\code{rfm_order_dist()} has been deprecated and will be made defunct. It has
been provided for compatibility with older versions only, and will be made
defunct at the next release.

Instead use the replacement function \code{rfm_plot_order_dist()}.
}

\examples{
# using transaction data
analysis_date <- as.Date('2006-12-31')
rfm_order <- rfm_table_order(rfm_data_orders, customer_id, order_date,
revenue, analysis_date)

# order distribution
rfm_plot_order_dist(rfm_order)

# horizontal bars
rfm_plot_order_dist(rfm_order, flip = TRUE)

# plotly
rfm_plot_order_dist(rfm_order, interactive = TRUE)

# using customer data
analysis_date <- as.Date('2007-01-01')
rfm_customer <- rfm_table_customer(rfm_data_customer, customer_id,
number_of_orders, recency_days, revenue, analysis_date)

# order distribution
rfm_plot_order_dist(rfm_customer)

}
