% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rfm-plots.R
\name{rfm_plot_histogram}
\alias{rfm_plot_histogram}
\alias{rfm_histograms}
\title{RFM histograms}
\usage{
rfm_plot_histogram(
  rfm_table,
  metric = "recency",
  hist_bins = 9,
  hist_color = NULL,
  plot_title = NULL,
  xaxis_label = NULL,
  yaxis_label = NULL,
  interactive = FALSE,
  print_plot = TRUE
)
}
\arguments{
\item{rfm_table}{An object of class \code{rfm_table}.}

\item{metric}{Metric to be visualized. Defaults to \code{"recency"}. Valid
 values are:
\itemize{
\item \code{"recency"}
\item \code{"frequency"}
\item \code{"monetary"}
}}

\item{hist_bins}{Number of bins of the histograms.}

\item{hist_color}{Color of the histogram.}

\item{plot_title}{Title of the plot.}

\item{xaxis_label}{X axis label.}

\item{yaxis_label}{Y axis label.}

\item{interactive}{If \code{TRUE}, uses \code{plotly} as the visualization
engine. If \code{FALSE}, uses \code{ggplot2}.}

\item{print_plot}{logical; if \code{TRUE}, prints the plot else returns a
plot object.}
}
\value{
Histograms
}
\description{
Histograms of recency, frequency and monetary value.
}
\section{Deprecated Functions}{

\code{rfm_histograms()} has been deprecated and will be made defunct. It has
been provided for compatibility with older versions only, and will be made
defunct at the next release.

Instead use the replacement function \code{rfm_plot_histogram()}.
}

\examples{
# using transaction data
analysis_date <- as.Date('2006-12-31')
rfm_order <- rfm_table_order(rfm_data_orders, customer_id, order_date,
revenue, analysis_date)

# histogram
# ggplot2
rfm_plot_histogram(rfm_order, metric = "frequency")

# plotly
rfm_plot_histogram(rfm_order, metric = "frequency", interactive = TRUE)

# using customer data
analysis_date <- as.Date('2007-01-01')
rfm_customer <- rfm_table_customer(rfm_data_customer, customer_id,
number_of_orders, recency_days, revenue, analysis_date)

# histogram
rfm_plot_histogram(rfm_customer)

}
